/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.context;

import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceLoader;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.spi.BeanFinder;
import org.togglz.core.spi.FeatureManagerProvider;
import org.togglz.core.util.Strings;

public class BeanFinderFeatureManagerProvider
implements FeatureManagerProvider {
    @Override
    public int priority() {
        return 60;
    }

    @Override
    public FeatureManager getFeatureManager() {
        HashSet<FeatureManager> managers = new HashSet<FeatureManager>();
        for (BeanFinder beanFinder : ServiceLoader.load(BeanFinder.class)) {
            Collection<FeatureManager> result = beanFinder.find(FeatureManager.class, null);
            if (result == null) continue;
            managers.addAll(result);
        }
        if (managers.size() > 1) {
            throw new IllegalStateException("Found more than one FeatureManager using the BeanFinder SPI: " + Strings.join(managers, ", "));
        }
        if (!managers.isEmpty()) {
            return (FeatureManager)managers.iterator().next();
        }
        return null;
    }
}

