/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.internal;

import java.util.ArrayList;
import java.util.List;

public class ModelReferenceParser {
    private final String data;
    private int i = 0;
    private final List<String> parts = new ArrayList<String>();

    public static Result parse(String modelReference) {
        return new ModelReferenceParser(modelReference).parse();
    }

    private ModelReferenceParser(String data) {
        this.data = data;
    }

    private Result parse() {
        this.parts.add(this.consumeIdent());
        while (!this.atEnd() && this.peek() != '.') {
            this.consume(':');
            if (this.atEnd()) {
                throw new IllegalArgumentException("Found broken module separator (`::`) at the end of " + this.data);
            }
            this.consume(':');
            if (this.atEnd()) {
                throw new IllegalArgumentException("Expected module or variable name after module separator (`::`) on " + this.data);
            }
            this.parts.add(this.consumeIdent());
        }
        int moduleParts = this.parts.size() - 1;
        if (this.atEnd()) {
            return new Result(moduleParts, this.parts);
        }
        do {
            this.consume('.');
            if (this.atEnd()) {
                throw new IllegalArgumentException("Expected field name after field selector (`.`) on " + this.data);
            }
            if (this.peek() == '\"') {
                this.parts.add(this.consumeQuotedString());
                continue;
            }
            this.parts.add(this.consumeIdent());
        } while (!this.atEnd());
        return new Result(moduleParts, this.parts);
    }

    private char peek() {
        if (this.atEnd()) {
            throw new IllegalStateException("Tried to peek characters outside the model reference");
        }
        return this.data.charAt(this.i);
    }

    private char consume() {
        if (this.atEnd()) {
            throw new IllegalStateException("Got a runaway syntactic element at " + this.data);
        }
        return this.data.charAt(this.i++);
    }

    private void consume(char expected) {
        char current = this.peek();
        if (current != expected) {
            throw new IllegalArgumentException("Expected `" + expected + "` at char " + this.i + " of " + this.data + " but got `" + current + "` instead");
        }
        ++this.i;
    }

    private boolean atEnd() {
        return this.data.length() <= this.i;
    }

    private String consumeIdent() {
        int start = this.i;
        if (!this.isValidIdentStart(this.peek())) {
            throw new IllegalArgumentException("`" + this.peek() + "` is not a valid identifier start at char" + this.i + " of " + this.data);
        }
        while (!this.atEnd() && this.isValidIdentRest(this.peek())) {
            this.consume();
        }
        return this.data.substring(start, this.i);
    }

    private String consumeQuotedString() {
        this.consume('\"');
        StringBuilder builder = new StringBuilder();
        while (!this.atEnd()) {
            char c = this.consume();
            if (c == '\"') {
                return builder.toString();
            }
            if (c == '\\') {
                char escaped = this.peek();
                this.consume();
                this.processEscape(escaped, builder);
                continue;
            }
            builder.append(c);
        }
        throw new IllegalArgumentException("Runaway quoted string found on " + this.data);
    }

    private void processEscape(char escaped, StringBuilder builder) {
        switch (escaped) {
            case '\"': 
            case '$': 
            case '\'': 
            case '/': 
            case '\\': {
                builder.append(escaped);
                break;
            }
            case 'n': {
                builder.append('\n');
                break;
            }
            case 'b': {
                builder.append('\b');
                break;
            }
            case 'f': {
                builder.append('\f');
                break;
            }
            case 'r': {
                builder.append('\r');
                break;
            }
            case 't': {
                builder.append('\t');
                break;
            }
            case 'u': {
                int start = this.i;
                try {
                    String s = "" + this.consume() + this.consume() + this.consume() + this.consume();
                    int codepoint = Integer.parseInt(s, 16);
                    builder.append(Character.toString(codepoint));
                    break;
                }
                catch (IllegalStateException | NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid codepoint escape at " + start + " of " + this.data, e);
                }
            }
            default: {
                builder.append('\\').append(escaped);
            }
        }
    }

    private boolean isValidIdentStart(char peek) {
        return 'a' <= peek && peek <= 'z' || 'A' <= peek && peek <= 'Z';
    }

    private boolean isValidIdentRest(char peek) {
        return this.isValidIdentStart(peek) || '0' <= peek && peek <= '9' || peek == '_';
    }

    public static class Result {
        private final int moduleDepth;
        private final List<String> parts;

        private Result(int moduleDepth, List<String> parts) {
            if (moduleDepth == 0) {
                throw new IllegalArgumentException("Cannot parse a variable reference that does not belong to any module");
            }
            this.moduleDepth = moduleDepth;
            this.parts = parts;
        }

        public int getModuleDepth() {
            return this.moduleDepth;
        }

        public List<String> getParts() {
            return this.parts;
        }
    }
}

