/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.model.CodeSourceLocation;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class Model {
    protected final @Nullable String modelReference;
    protected final transient @Nullable CodeSourceLocation sourceLocation;

    protected Model(@Nullable String modelReference) {
        this.modelReference = modelReference;
        if (modelReference == null) {
            this.sourceLocation = null;
        } else {
            try {
                this.sourceLocation = CodeSourceLocation.from(modelReference);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new IllegalArgumentException("Invalid model reference: " + modelReference, e);
            }
        }
    }

    public Optional<String> getModelReference() {
        return Optional.ofNullable(this.modelReference);
    }

    public Optional<CodeSourceLocation> getSourceLocation() {
        return Optional.ofNullable(this.sourceLocation);
    }

    public static abstract class Builder<M extends Model, T extends Builder<M, T>> {
        protected @Nullable String modelReference;

        protected abstract M createInstance();

        protected abstract T getThis();

        public M build() {
            return this.createInstance();
        }

        public T withModelReference(@Nullable String modelReference) {
            this.modelReference = modelReference;
            return this.getThis();
        }
    }
}

