/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.model.Model;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;

public class BaseExecutableComponentModel<T extends BaseExecutableComponentModel<?>>
extends Model {
    protected final String name;
    private final NavigableMap<Integer, T> extraVersions;
    protected final transient NavigableMap<Integer, T> versions;
    private final transient boolean base;
    private final boolean isPaginated;

    public BaseExecutableComponentModel(@Nullable String modelReference, String name, NavigableMap<Integer, T> extraVersions, boolean base, boolean isPaginated) {
        super(modelReference);
        this.name = name;
        this.extraVersions = extraVersions;
        this.versions = new TreeMap<Integer, T>(extraVersions);
        this.base = base;
        this.versions.put(1, this);
        this.isPaginated = isPaginated;
        if (!base && !extraVersions.isEmpty()) {
            throw new IllegalArgumentException("Non-base component cannot have versions! (versions: " + String.valueOf(extraVersions) + ").");
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isPaginated() {
        return this.isPaginated;
    }

    public NavigableMap<Integer, T> getVersions() {
        if (!this.base) {
            throw new UnsupportedOperationException("Non-base operation cannot return a list of versions");
        }
        return this.versions;
    }

    public boolean isBase() {
        return this.base;
    }

    public static class ExecutableComponentBuilder
    extends AbstractExecutableComponentBuilder<BaseExecutableComponentModel<?>, ExecutableComponentBuilder> {
        @Override
        protected BaseExecutableComponentModel<?> createInstance() {
            return new BaseExecutableComponentModel(this.modelReference, Objects.requireNonNull(this.name, "name"), Objects.requireNonNullElse(this.versions, new TreeMap()), this.base, this.isPaginated);
        }

        @Override
        protected ExecutableComponentBuilder getThis() {
            return this;
        }
    }

    public static abstract class AbstractExecutableComponentBuilder<M extends BaseExecutableComponentModel<?>, T extends AbstractExecutableComponentBuilder<M, T>>
    extends Model.Builder<M, T> {
        protected @Nullable String name;
        protected @Nullable NavigableMap<Integer, M> versions;
        protected boolean base = true;
        protected boolean isPaginated = false;

        public T withName(String name) {
            this.name = name;
            return (T)((AbstractExecutableComponentBuilder)this.getThis());
        }

        public T withVersions(NavigableMap<Integer, M> versions) {
            this.versions = versions;
            return (T)((AbstractExecutableComponentBuilder)this.getThis());
        }

        public T withIsBase(boolean base) {
            this.base = base;
            return (T)((AbstractExecutableComponentBuilder)this.getThis());
        }

        public T withIsPaginated(boolean isPaginated) {
            this.isPaginated = isPaginated;
            return (T)((AbstractExecutableComponentBuilder)this.getThis());
        }
    }
}

