/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import com.mulesoft.connectivity.linkweave.api.loader.InvalidConnectorException;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ContextReferenceVariable;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderArgument;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.model.provider.TypeReferenceExpression;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.BooleanType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.DWTypeVisitor;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.TypeSelectorType;
import org.mule.weave.v2.api.tooling.ts.UnionType;

public class ContextVariablesResolver {
    private ContextVariablesResolver() {
    }

    public static Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> resolveContextVariablesOnInput(DWType weaveType, ObjectFieldSelector objectFieldSelector, BiConsumer<String, Location> reporter) {
        return ContextVariablesResolver.resolveContextVariables(weaveType, weaveType, true, objectFieldSelector, reporter);
    }

    public static Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> resolveContextVariablesOnInput(DWType weaveType) {
        return ContextVariablesResolver.resolveContextVariablesOnInput(weaveType, null, ContextVariablesResolver::throwInvalidConnector);
    }

    public static Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> resolveContextVariablesOnOutput(DWType weaveType, DWType context, ObjectFieldSelector fieldSelector, BiConsumer<String, Location> reporter) {
        return ContextVariablesResolver.resolveContextVariables(weaveType, context, false, fieldSelector, reporter);
    }

    public static Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> resolveContextVariablesOnOutput(DWType weaveType, DWType context) {
        if (weaveType == context) {
            throw new IllegalArgumentException("Resolution of an output type uses needs also access to the input type, but the same type was passed twice.");
        }
        return ContextVariablesResolver.resolveContextVariablesOnOutput(weaveType, context, null, ContextVariablesResolver::throwInvalidConnector);
    }

    public static Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> resolveContextVariables(DWType weaveType, DWType context, ObjectFieldSelector fieldSelector, BiConsumer<String, Location> reporter) {
        return ContextVariablesResolver.resolveContextVariables(weaveType, context, weaveType == context, fieldSelector, reporter);
    }

    public static Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> resolveContextVariables(DWType weaveType, DWType context, boolean isInput, ObjectFieldSelector fieldSelector, BiConsumer<String, Location> reporter) {
        WeaveTypeContextVariablesResolverVisitor visitor = new WeaveTypeContextVariablesResolverVisitor(context, reporter, isInput, fieldSelector);
        visitor.enter(weaveType);
        return visitor.references;
    }

    private static void throwInvalidConnector(String msg, Location location) {
        throw new InvalidConnectorException(msg, location);
    }

    private static class WeaveTypeContextVariablesResolverVisitor
    implements DWTypeVisitor {
        private final Set<String> currentlyVisiting = new HashSet<String>();
        private final Deque<String> path = new ArrayDeque<String>();
        private final Deque<Map<String, TypeReferenceExpression>> scopes = new ArrayDeque<Map<String, TypeReferenceExpression>>();
        private final Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> references = new HashMap<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences>();
        private final DWType root;
        private final BiConsumer<String, Location> reporter;
        private final boolean isInput;
        private final ObjectFieldSelector fieldSelector;

        WeaveTypeContextVariablesResolverVisitor(DWType root, BiConsumer<String, Location> reporter, boolean isInput, ObjectFieldSelector fieldSelector) {
            this.root = root;
            this.reporter = reporter;
            this.isInput = isInput;
            this.fieldSelector = fieldSelector;
            this.scopes.push(Map.of());
        }

        private void enter(DWType weaveType) {
            weaveType.accept((DWTypeVisitor)this);
        }

        public void visitSimpleReferenceType(SimpleReferenceType simpleReferenceType) {
            this.visitReferenceType((ReferenceType)simpleReferenceType);
        }

        public void visitTypeSelectorType(TypeSelectorType typeSelectorType) {
            this.visitReferenceType((ReferenceType)typeSelectorType);
        }

        private void visitReferenceType(ReferenceType referenceType) {
            if (this.currentlyVisiting.add(referenceType.getReferenceFQName())) {
                try {
                    this.visitTypeWithMetadata((DWType)referenceType, () -> this.enter(referenceType.resolveType()));
                }
                finally {
                    this.currentlyVisiting.remove(referenceType.getReferenceFQName());
                }
            }
        }

        public void visitIntersectionType(IntersectionType interSectionType) {
            for (DWType type : interSectionType.intersectionOf()) {
                this.enter(type);
            }
        }

        public void visitUnionType(UnionType unionType) {
            this.visitTypeWithMetadata((DWType)unionType, () -> {
                for (DWType field : unionType.unionOf()) {
                    this.enter(field);
                }
            });
        }

        public void visit(DWType aType) {
            this.getValueProvider(aType).ifPresent(providerReference -> this.references.put(this.pathAsSelector(), new ExecutableComponentModel.ProviderReferences((ProviderReference)providerReference, null)));
        }

        public void visitObjectType(ObjectType objectType) {
            this.visitTypeWithMetadata((DWType)objectType, () -> {
                for (KeyValuePairType field : objectType.getProperties()) {
                    KeyValuePairType keyValuePairType;
                    if (this.fieldSelector != null && (!(field instanceof KeyValuePairType) || !this.isNextPathOnSelector((keyValuePairType = field).getKeyName()))) continue;
                    this.enter((DWType)field);
                }
            });
        }

        private void visitTypeWithMetadata(DWType type, Runnable runnable) {
            Map b = WeaveTypeContextVariablesResolverVisitor.getBindings(type).map(bindings -> bindings.entrySet().stream().map(e -> {
                TypeReferenceExpression typeReferenceExpression;
                String key;
                TypeReferenceExpression v = (TypeReferenceExpression)e.getValue();
                if (v instanceof ContextReferenceVariable) {
                    throw new UnsupportedOperationException("!");
                }
                String k = (String)e.getKey();
                String string = key = k.startsWith("#") ? k.substring("#".length()) : k;
                if (v instanceof ObjectFieldSelector) {
                    ObjectFieldSelector objectFieldSelector = (ObjectFieldSelector)v;
                    typeReferenceExpression = this.resolve(this.pathAsSelector(), objectFieldSelector, this.isInput, () -> "Context variable '" + key + "'", type.getLocation());
                } else {
                    typeReferenceExpression = v;
                }
                TypeReferenceExpression ref = typeReferenceExpression;
                return Map.entry(key, ref);
            }).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue))).orElse(Map.of());
            this.scopes.addLast(b);
            this.getMetadataProvider(type).ifPresent(providerReference -> this.references.put(this.pathAsSelector(), new ExecutableComponentModel.ProviderReferences(null, (ProviderReference)providerReference)));
            this.getValueProvider(type).ifPresent(providerReference -> this.references.put(this.pathAsSelector(), new ExecutableComponentModel.ProviderReferences((ProviderReference)providerReference, null)));
            runnable.run();
            this.scopes.removeLast();
        }

        public void visitKeyValuePairType(KeyValuePairType keyValuePairType) {
            this.path.addLast(keyValuePairType.getKeyName());
            this.enter(keyValuePairType.getValue());
            this.path.removeLast();
        }

        private static Optional<Map<String, TypeReferenceExpression>> getBindings(DWType weaveType) {
            return MetadataUtils.getBindings(weaveType);
        }

        private Optional<ProviderReference> getValueProvider(DWType weaveType) {
            return this.isInput ? MetadataUtils.getValueProvider(weaveType).map(ref -> this.getProviderReferenceWithContextVariablesResolved((ProviderReference)ref, weaveType.getLocation())) : Optional.empty();
        }

        private Optional<ProviderReference> getMetadataProvider(DWType weaveType) {
            return MetadataUtils.getMetadataProvider(weaveType).map(ref -> this.getProviderReferenceWithContextVariablesResolved((ProviderReference)ref, weaveType.getLocation()));
        }

        private ProviderReference getProviderReferenceWithContextVariablesResolved(ProviderReference ref, Location location) {
            return new ProviderReference(ref.getName(), this.getProviderArguments(ref, location));
        }

        private List<ProviderArgument> getProviderArguments(ProviderReference ref, Location location) {
            return ref.getArguments().stream().map(a -> {
                TypeReferenceExpression inputSelector = a.getInputSelector();
                ObjectFieldSelector parameterSelector = a.getParameterSelector();
                if (inputSelector instanceof ContextReferenceVariable) {
                    ContextReferenceVariable v = (ContextReferenceVariable)inputSelector;
                    return new ProviderArgument(parameterSelector, this.resolveContextVariable(v.getName(), location));
                }
                if (inputSelector instanceof ObjectFieldSelector) {
                    ObjectFieldSelector sel = (ObjectFieldSelector)inputSelector;
                    ObjectFieldSelector context = this.parentPathAsSelector();
                    return new ProviderArgument(parameterSelector, this.resolve(context, sel, true, () -> "Value passed into parameter selector '" + String.valueOf(parameterSelector) + "'", location));
                }
                throw new IllegalStateException("Unknown selector type: " + String.valueOf(inputSelector.getClass()));
            }).toList();
        }

        private ObjectFieldSelector resolve(ObjectFieldSelector context, ObjectFieldSelector selector, boolean validate, Supplier<String> what, Location location) {
            ObjectFieldSelector resolved = context.resolve(selector);
            if (validate && resolved.evaluateOn(this.root).isEmpty()) {
                String m = selector.isRelative() ? "Selector '" + String.valueOf(selector) + "' resolves to '" + String.valueOf(resolved) + "', which doesn't exist in the type: " + String.valueOf(this.root) : "Selector '" + String.valueOf(resolved) + "' doesn't exist in the type: " + String.valueOf(this.root);
                this.reporter.accept(what.get() + ": " + m, location);
            }
            return resolved;
        }

        private ObjectFieldSelector pathAsSelector() {
            return new ObjectFieldSelector(false, (String[])this.path.toArray(String[]::new));
        }

        private ObjectFieldSelector parentPathAsSelector() {
            return this.path.isEmpty() ? this.pathAsSelector() : new ObjectFieldSelector(false, (String[])this.path.stream().limit((long)this.path.size() - 1L).toArray(String[]::new));
        }

        private boolean isNextPathOnSelector(String nextKey) {
            int expectedLength;
            if (this.fieldSelector == null) {
                return true;
            }
            String[] selectorPath = this.fieldSelector.getPath();
            if (selectorPath.length < (expectedLength = this.path.size() + 1)) {
                return false;
            }
            int i = 0;
            for (String segment : this.path) {
                if (segment.equals(selectorPath[i++])) continue;
                return false;
            }
            return selectorPath[i].equals(nextKey);
        }

        private TypeReferenceExpression resolveContextVariable(String name, Location location) {
            Iterator<Map<String, TypeReferenceExpression>> it = this.scopes.descendingIterator();
            while (it.hasNext()) {
                Map<String, TypeReferenceExpression> i = it.next();
                if (!i.containsKey(name)) continue;
                return i.get(name);
            }
            this.reporter.accept("There's no context variable '" + name + "' defined at this point: " + String.valueOf(this.pathAsSelector()) + ". Available variables: " + String.valueOf(this.scopes.stream().flatMap(s -> s.keySet().stream()).distinct().toList()), location);
            return ObjectFieldSelector.create("/");
        }

        public void visitBooleanType(BooleanType booleanType) {
            this.visit((DWType)booleanType);
        }

        public void visitStringType(StringType stringType) {
            this.visit((DWType)stringType);
        }

        public void visitNumberType(NumberType numberType) {
            this.visit((DWType)numberType);
        }

        public void visitArrayType(ArrayType arrayType) {
            this.visitTypeWithMetadata((DWType)arrayType, () -> this.enter(arrayType.arrayOf()));
        }
    }
}

