/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.DataWeaveReference;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.model.Model;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.FunctionType;

public abstract class ConnectionProviderLoader<M extends ConnectionProviderModel, B extends ConnectionProviderModel.AbstractConnectionBuilder<M, B>>
extends ModelLoader<M, B, DataWeaveObjectReference> {
    protected final ModelLoader<TestConnectionModel, TestConnectionModel.Builder, DataWeaveObjectReference> testConnectionLoader;

    protected ConnectionProviderLoader(ModelLoader<TestConnectionModel, TestConnectionModel.Builder, DataWeaveObjectReference> testConnectionLoader) {
        this.testConnectionLoader = testConnectionLoader;
    }

    @Override
    public B configureBuilder(B builder, DataWeaveObjectReference connectionObject, @Nullable String name) {
        FunctionType functionType = TypeUtils.resolveFunctionType(TypeUtils.requireObjectPropertyType(connectionObject.getType(), "connect"));
        ((ConnectionProviderModel.AbstractConnectionBuilder)((ConnectionProviderModel.AbstractConnectionBuilder)builder).authenticationType(connectionObject.getObjectProperty("authenticationType").map(DataWeaveReference::getValue).map(this::getAuthenticationType).orElse(null))).inputType(TypeUtils.inputType(functionType));
        if (((Map)connectionObject.getValue()).get("validate") != null) {
            ((ConnectionProviderModel.AbstractConnectionBuilder)builder).testConnection(this.testConnectionLoader.loadModel(connectionObject, null));
        }
        ((ConnectionProviderModel.AbstractConnectionBuilder)builder).hasExtensions(((Map)connectionObject.getValue()).get("extensions") != null);
        ((ConnectionProviderModel.AbstractConnectionBuilder)builder).name(Objects.requireNonNull(name, "Connection must have a name"));
        return (B)((ConnectionProviderModel.AbstractConnectionBuilder)((Model.Builder)builder).withModelReference(connectionObject.getPath()));
    }

    private @Nullable AuthenticationType getAuthenticationType(Map<?, ?> connectionValue) {
        if (connectionValue.isEmpty()) {
            return null;
        }
        HttpAuthenticationType.Type type = HttpAuthenticationType.Type.fromString((String)connectionValue.get("type"));
        return type.createHttpAuthenticationType(connectionValue);
    }
}

