/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.interpreter.Page;
import com.mulesoft.connectivity.linkweave.api.interpreter.Result;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.values.StringValue;
import scala.Option;

public class Content
implements Result {
    private final DataWeaveLiveValue liveValue;
    private final boolean serialize;

    Content(DataWeaveLiveValue liveValue) {
        this(liveValue, false);
    }

    Content(DataWeaveLiveValue liveValue, boolean serialize) {
        this.liveValue = liveValue;
        this.serialize = serialize;
    }

    public @Nullable Object get() {
        return this.liveValue.evalToNullableJava("result");
    }

    public Optional<InputStream> raw() {
        String rawScript = this.serialize ? "write(result, result.^mimeType default 'application/json') as Binary" : "result.^raw";
        return Optional.ofNullable(this.liveValue.evalToNullableJava(rawScript)).filter(InputStream.class::isInstance).map(InputStream.class::cast);
    }

    public Optional<String> rawContentType() {
        String ct = this.contentType();
        return ct == null ? Optional.ofNullable(this.serialize ? "application/json" : null) : Optional.of(ct);
    }

    private @Nullable String contentType() {
        String string;
        Schema resultMetadata = (Schema)this.getResultMetadata().getOrElse(() -> null);
        if (resultMetadata == null) {
            return null;
        }
        Object object = resultMetadata.valueOf(Schema.MIME_TYPE_PROPERTY_NAME(), null).getOrElse(() -> null);
        if (object instanceof StringValue) {
            StringValue sv = (StringValue)object;
            string = (String)sv.evaluate(null);
        } else {
            string = null;
        }
        return string;
    }

    public Optional<Map<String, Object>> getTransportAttributes() {
        return Optional.ofNullable(this.liveValue.evalToNullableJava("result.^transportAttributes")).filter(Map.class::isInstance).map(Map.class::cast);
    }

    @Override
    public void close() {
        this.liveValue.close();
    }

    @Override
    public boolean isPage() {
        return false;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    public Page<Object> asPage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Content asContent() {
        return this;
    }

    private Option<Schema> getResultMetadata() {
        return this.liveValue.getExecuteResult().getResultMaterialized().schema(null);
    }
}

