/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.utils.ClassUtils;

public class CachedClassTypeLoader
implements ClassTypeLoader {
    private final ClassTypeLoader classTypeLoader;
    private final Map<String, Optional<MetadataType>> typeIdentifierMetadataTypeMap = new WeakHashMap<String, Optional<MetadataType>>();
    private final Map<Type, MetadataType> typeMetadataTypeMap = new WeakHashMap<Type, MetadataType>();

    public CachedClassTypeLoader(ClassTypeLoader classTypeLoader) {
        Objects.requireNonNull(classTypeLoader, "classTypeLoader cannot be null");
        this.classTypeLoader = classTypeLoader;
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        return this.typeIdentifierMetadataTypeMap.computeIfAbsent(typeIdentifier, this::doLoad);
    }

    private Optional<MetadataType> doLoad(String typeIdentifier) {
        Class<?> clazz;
        if (Void.TYPE.getName().equals(typeIdentifier) || Void.class.getName().equals(typeIdentifier)) {
            return Optional.of(BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).voidType().build());
        }
        try {
            clazz = this.getClassLoader().loadClass(typeIdentifier);
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = this.getClassLoader().loadClass(ClassUtils.getInnerClassName((String)typeIdentifier));
            }
            catch (ClassNotFoundException innerClassNotFound) {
                return Optional.empty();
            }
        }
        return Optional.of(this.load(clazz));
    }

    public MetadataType load(Type type) {
        return this.typeMetadataTypeMap.computeIfAbsent(type, k -> {
            MetadataType metadataType = this.classTypeLoader.load(k);
            MetadataTypeUtils.getTypeId((MetadataType)metadataType).ifPresent(t -> this.typeIdentifierMetadataTypeMap.put((String)t, Optional.of(metadataType)));
            return metadataType;
        });
    }

    public ClassLoader getClassLoader() {
        return this.classTypeLoader.getClassLoader();
    }
}

