/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.function;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.AbstractParameterizedModel;

public class ImmutableFunctionModel
extends AbstractParameterizedModel
implements FunctionModel {
    private final OutputModel output;
    private final DeprecationModel deprecationModel;
    private final MuleVersion minMuleVersion;

    public ImmutableFunctionModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, OutputModel output, DisplayModel displayModel, Set<ModelProperty> modelProperties) {
        this(name, description, parameterGroupModels, output, displayModel, modelProperties, null);
    }

    public ImmutableFunctionModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, OutputModel output, DisplayModel displayModel, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel) {
        this(name, description, parameterGroupModels, output, displayModel, modelProperties, deprecationModel, null);
    }

    public ImmutableFunctionModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, OutputModel output, DisplayModel displayModel, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel, MuleVersion minMuleVersion) {
        super(name, description, parameterGroupModels, displayModel, modelProperties);
        this.output = output;
        this.deprecationModel = deprecationModel;
        this.minMuleVersion = minMuleVersion;
    }

    public OutputModel getOutput() {
        return this.output;
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return Optional.ofNullable(this.deprecationModel);
    }

    public boolean isDeprecated() {
        return this.deprecationModel != null;
    }

    public Optional<MuleVersion> getMinMuleVersion() {
        return Optional.ofNullable(this.minMuleVersion);
    }

    @Override
    public String toString() {
        return "ImmutableFunctionModel{output=" + this.output + ", deprecationModel=" + this.deprecationModel + ", minMuleVersion=" + this.minMuleVersion + "} " + super.toString();
    }
}

