/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.server;

import com.mulesoft.mule.munit.recording.commons.RecordingSystemProperties;
import com.mulesoft.mule.munit.recording.commons.net.Connection;
import com.mulesoft.mule.munit.recording.commons.net.Listener;
import com.mulesoft.mule.munit.recording.commons.net.Server;
import com.mulesoft.mule.munit.recording.commons.wrappers.Container;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.lifecycle.StartException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RecordingServer
implements Listener,
Lifecycle {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(RecordingServer.class);
    private static RecordingServer instance;
    private Server connection;
    private boolean running;

    private RecordingServer() {
    }

    static RecordingServer getInstance() {
        if (instance == null) {
            instance = new RecordingServer();
        }
        return instance;
    }

    public void initialise() {
        if (this.connection == null) {
            this.connection = new Server(new Listener[]{new Listener.ThreadedListener((Listener)this)});
            LOGGER.info("Initialised");
        }
    }

    public void start() throws StartException {
        if (!this.running && this.connection != null) {
            try {
                this.running = true;
                this.connection.connect(Integer.getInteger(RecordingSystemProperties.PORT.toString()).intValue());
                LOGGER.info("Started");
            }
            catch (Exception cause) {
                this.stop();
                String message = "There was a problem while starting the recording server";
                I18nMessage exceptionMessage = I18nMessageFactory.createStaticMessage((String)message);
                LOGGER.error(message, (Throwable)cause);
                throw new StartException(exceptionMessage, (Throwable)cause, (Startable)this);
            }
        }
    }

    public synchronized void received(Connection connection, Object object) {
        if (object instanceof Container) {
            Container container = (Container)object;
            switch (container.type()) {
                case OK: {
                    return;
                }
                case ERROR: {
                    LOGGER.error(String.format("Received an ERROR response: %s", container.get(Container.Key.MESSAGE)));
                    return;
                }
            }
        }
        LOGGER.error(String.format("Received an unexpected object from the client: %s", object));
        connection.send((Object)new Container(Container.Type.ERROR, new Container.Entry[]{new Container.Entry(Container.Key.MESSAGE, (Object)String.format("Unexpected: '%s'", object))}));
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.connection.close();
            LOGGER.info("Stopped");
        }
    }

    public void dispose() {
        if (!this.running && this.connection != null) {
            this.connection.clearListeners();
            this.connection = null;
            LOGGER.info("Disposed");
        }
    }

    void send(Object object) {
        if (this.running) {
            this.connection.send(object);
        }
    }
}

