/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.server;

import com.mulesoft.mule.munit.recording.commons.RecordingSystemProperties;
import com.mulesoft.mule.munit.recording.server.RecordingInterceptorFactory;
import com.mulesoft.mule.munit.recording.server.RecordingServer;
import com.mulesoft.mule.runtime.module.plugin.api.MulePlugin;
import com.mulesoft.mule.runtime.module.plugin.api.deployment.DeploymentListenerProvider;
import java.io.File;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordingPlugin
implements MulePlugin,
DeploymentListener,
DeploymentListenerProvider {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(RecordingPlugin.class);

    public void onArtifactCreated(String artifactName, CustomizationService customizationService) {
        if (!this.isDisabledOnEnvironment() && System.getProperty(RecordingSystemProperties.APP.toString()).equals(artifactName)) {
            customizationService.registerCustomServiceClass("recording.interceptor", RecordingInterceptorFactory.class);
            LOGGER.info("Registered");
        }
    }

    public boolean isDisabledOnEnvironment() {
        return !Boolean.getBoolean(RecordingSystemProperties.ENABLE.toString());
    }

    public DeploymentListener getDeploymentListener() {
        return this;
    }

    public void initialise() throws InitialisationException {
        if (!this.isDisabledOnEnvironment()) {
            try {
                RecordingServer.getInstance().initialise();
                RecordingServer.getInstance().start();
                LOGGER.info("Initialised");
            }
            catch (Exception cause) {
                throw new InitialisationException((Throwable)cause, (Initialisable)this);
            }
        }
    }

    public void start() {
        if (!this.isDisabledOnEnvironment()) {
            LOGGER.info("Started");
        }
    }

    public void stop() {
        if (!this.isDisabledOnEnvironment()) {
            LOGGER.info("Stopped");
        }
    }

    public void dispose() {
        if (!this.isDisabledOnEnvironment()) {
            RecordingServer.getInstance().stop();
            RecordingServer.getInstance().dispose();
            LOGGER.info("Disposed");
        }
    }

    public void setWorkingDirectory(File ignored) {
    }
}

