/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.transport;

import com.mulesoft.mule.debugger.request.ErrorRequest;
import com.mulesoft.mule.debugger.request.ExitDebuggerRequest;
import com.mulesoft.mule.debugger.request.IDebuggerRequest;
import com.mulesoft.mule.debugger.response.ErrorResponse;
import com.mulesoft.mule.debugger.response.ExitDebuggerResponse;
import com.mulesoft.mule.debugger.response.IDebuggerServerEvent;
import com.mulesoft.mule.debugger.transport.IClientDebuggerProtocol;
import com.mulesoft.mule.debugger.transport.IServerDebuggerProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SerializeDebuggerProtocol
implements IClientDebuggerProtocol,
IServerDebuggerProtocol {
    private ObjectInputStream input;
    private ObjectOutputStream output;
    private final Lock singleSend = new ReentrantLock();

    public SerializeDebuggerProtocol(InputStream input, OutputStream output) {
        try {
            this.output = new ObjectOutputStream(output);
            this.input = new ObjectInputStream(input);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendRequest(IDebuggerRequest request) {
        try {
            this.singleSend.lock();
            this.output.reset();
            this.output.writeObject(request);
            this.output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.singleSend.unlock();
        }
    }

    @Override
    public IDebuggerServerEvent getResponse() {
        try {
            return (IDebuggerServerEvent)this.input.readObject();
        }
        catch (IOException e) {
            return new ExitDebuggerResponse();
        }
        catch (Exception e) {
            return new ErrorResponse(e.getMessage());
        }
    }

    @Override
    public IDebuggerRequest getRequest() {
        try {
            return (IDebuggerRequest)this.input.readObject();
        }
        catch (IOException e) {
            return new ExitDebuggerRequest();
        }
        catch (Exception e) {
            return new ErrorRequest(e);
        }
    }

    @Override
    public void sendResponse(IDebuggerServerEvent response) {
        try {
            this.singleSend.lock();
            this.output.reset();
            this.output.writeObject(response);
            this.output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.singleSend.unlock();
        }
    }

    public void close() {
        try {
            this.output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

