/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server;

import com.mulesoft.mule.debugger.MuleDebuggingContext;
import com.mulesoft.mule.debugger.response.ResumeEvent;
import com.mulesoft.mule.debugger.server.BreakpointHandler;
import com.mulesoft.mule.debugger.server.CorrelationIdProvider;
import com.mulesoft.mule.debugger.server.DebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.server.DebuggerManager;
import com.mulesoft.mule.debugger.server.MessageNotificationsStatus;
import com.mulesoft.mule.debugger.server.MuleNotificationHandler;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;

public class MuleNotificationDebuggerHandlerImpl
implements MuleNotificationHandler {
    private final DebuggerClientConnectionHandler clientConnectionHandler;
    private final DebuggerManager messageDebuggerManager;
    private final BreakpointHandler breakpointHandler;
    private final ConcurrentHashMap<String, MessageNotificationsStatus> notificationsStatusMap;

    public MuleNotificationDebuggerHandlerImpl(BreakpointHandler breakpointHandler, DebuggerManager messageDebuggerManager, DebuggerClientConnectionHandler clientConnectionHandler) {
        this.breakpointHandler = breakpointHandler;
        this.messageDebuggerManager = messageDebuggerManager;
        this.clientConnectionHandler = clientConnectionHandler;
        this.notificationsStatusMap = new ConcurrentHashMap();
    }

    @Override
    public void onApplicationDown(String applicationName) {
        MuleDebuggingContext currentEvent = this.messageDebuggerManager.getMuleExecutionManager().getDebuggingEvent();
        if (currentEvent != null && currentEvent.getAppName().equals(applicationName)) {
            this.messageDebuggerManager.stopAllDebuggingSessions();
        }
    }

    @Override
    public void onMuleMessageArrived(MuleDebuggingContext muleDebuggingContext) {
        if (!this.clientConnectionHandler.isClientConnected()) {
            return;
        }
        if (this.breakpointHandler.isBreakpointOn(muleDebuggingContext.getExpressionManager(), muleDebuggingContext.getInterceptionEvent(), muleDebuggingContext.getComponentLocation(), muleDebuggingContext.getAppName(), muleDebuggingContext.getTransformationService())) {
            this.messageDebuggerManager.isStepping(muleDebuggingContext.getIdProvider());
            this.messageDebuggerManager.startDebugging(muleDebuggingContext.getInterceptionEvent());
            this.messageDebuggerManager.getMuleExecutionManager().stopExecution(muleDebuggingContext);
        } else if (Boolean.TRUE.equals(this.messageDebuggerManager.isStepping(muleDebuggingContext.getIdProvider()))) {
            this.messageDebuggerManager.startDebugging(muleDebuggingContext.getInterceptionEvent());
            this.messageDebuggerManager.getMuleExecutionManager().stopExecution(muleDebuggingContext);
        } else {
            this.messageDebuggerManager.setStepping(muleDebuggingContext.getInterceptionEvent(), false);
        }
    }

    private boolean isASmartConnector(ComponentLocation componentLocation) {
        List parts = componentLocation.getParts();
        if (!parts.isEmpty()) {
            return ((LocationPart)parts.get(0)).getPartIdentifier().map(TypedComponentIdentifier::getType).map(arg_0 -> TypedComponentIdentifier.ComponentType.OPERATION.equals(arg_0)).orElse(false);
        }
        return false;
    }

    @Override
    public void onMuleMessageLeft(MuleDebuggingContext debuggingContext) {
    }

    @Override
    public void onExceptionThrown(MuleDebuggingContext debuggingContext, Throwable exception) {
        if (!this.clientConnectionHandler.isClientConnected() || !this.breakpointHandler.isExceptionBreakpoint() || this.isASmartConnector(debuggingContext.getComponentLocation())) {
            return;
        }
        this.messageDebuggerManager.isStepping(debuggingContext.getIdProvider());
        this.messageDebuggerManager.startDebugging(debuggingContext.getInterceptionEvent());
        this.messageDebuggerManager.getMuleExecutionManager().stopExecution(debuggingContext, exception);
    }

    @Override
    public void onPipelineStartReached(CorrelationIdProvider muleEvent) {
        this.getMessageNotificationsStatus(muleEvent).flowStarted();
    }

    @Override
    public void onPipelineCompleteReached(CorrelationIdProvider muleEvent) {
        MessageNotificationsStatus messageNotificationsStatus = this.getMessageNotificationsStatus(muleEvent);
        messageNotificationsStatus.flowEnded();
        this.checkFinished(muleEvent, messageNotificationsStatus);
    }

    @Override
    public void onPipelineCompleteWithExceptionReached(CorrelationIdProvider muleMessage, Exception exception) {
        MessageNotificationsStatus messageNotificationsStatus = this.getMessageNotificationsStatus(muleMessage);
        this.getMessageNotificationsStatus(muleMessage).flowEnded();
        this.checkFinished(muleMessage, messageNotificationsStatus);
    }

    @Override
    public void onErrorHandlingComplete(CorrelationIdProvider debuggingContext) {
        MessageNotificationsStatus messageNotificationsStatus = this.getMessageNotificationsStatus(debuggingContext);
        messageNotificationsStatus.exceptionStrategyEnded();
        this.checkFinished(debuggingContext, messageNotificationsStatus);
    }

    @Override
    public void onErrorHandlingStarted(CorrelationIdProvider debuggingContext) {
        this.getMessageNotificationsStatus(debuggingContext).exceptionStrategyStarted();
    }

    private MessageNotificationsStatus getMessageNotificationsStatus(CorrelationIdProvider muleEvent) {
        MessageNotificationsStatus newValue;
        String correlationId = muleEvent.getCorrelationId();
        MessageNotificationsStatus result = this.notificationsStatusMap.get(correlationId);
        if (result == null && (result = this.notificationsStatusMap.putIfAbsent(correlationId, newValue = new MessageNotificationsStatus())) == null) {
            result = newValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFinished(CorrelationIdProvider muleEvent, MessageNotificationsStatus messageNotificationsStatus) {
        String correlationId = muleEvent.getCorrelationId();
        MessageNotificationsStatus messageNotificationsStatus2 = messageNotificationsStatus;
        synchronized (messageNotificationsStatus2) {
            if (messageNotificationsStatus.isFinish()) {
                this.notificationsStatusMap.remove(correlationId);
                if (this.clientConnectionHandler.isClientConnected() && this.messageDebuggerManager.isDebuggingThisMessage(muleEvent) && this.messageDebuggerManager.isStepping(muleEvent) != null) {
                    this.messageDebuggerManager.stopDebugging();
                    this.clientConnectionHandler.getClientCommunicationService().sendEvent(new ResumeEvent());
                }
            }
        }
    }
}

