/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server;

import com.mulesoft.mule.debugger.MuleDebuggingContext;
import com.mulesoft.mule.debugger.response.FieldNode;
import com.mulesoft.mule.debugger.response.FieldPath;
import com.mulesoft.mule.debugger.response.MessageProcessorInfo;
import com.mulesoft.mule.debugger.response.MuleMessageInfo;
import com.mulesoft.mule.debugger.response.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.response.ObjectFieldDefinitionFactory;
import com.mulesoft.mule.debugger.util.DataWeaveUtils;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;

public class MuleMessageInfoBuilder {
    public static final String MEDIA_TYPE_NAME = "^mediaType";

    public static MuleMessageInfo create(MuleDebuggingContext debuggingContext) {
        InterceptionEvent interceptionEvent = debuggingContext.getInterceptionEvent();
        MuleMessageInfo result = new MuleMessageInfo();
        result.setAppName(debuggingContext.getAppName());
        result.setCorrelationId(interceptionEvent.getContext().getCorrelationId());
        result.setMessageProcessorInfo(MuleMessageInfoBuilder.createMessageProcessorInfo(debuggingContext));
        Message message = interceptionEvent.getMessage();
        Charset charset = MuleMessageInfoBuilder.calculateCharset(message.getPayload().getDataType());
        MuleMessageInfoBuilder.addPayloadDefinitions(result, message, charset);
        MuleMessageInfoBuilder.addVariablesDefinitions(interceptionEvent, result);
        MuleMessageInfoBuilder.addErrorDefinition(interceptionEvent, result, charset);
        result.addDefinition(ObjectFieldDefinitionFactory.createSimpleField(interceptionEvent.getCorrelationId(), interceptionEvent.getCorrelationId().getClass(), "correlationId", 0, new FieldPath("correlationId"), false, "correlationId"));
        interceptionEvent.getItemSequenceInfo().ifPresent(itemSequenceInfo -> result.addDefinition(ObjectFieldDefinitionFactory.createFromObject(itemSequenceInfo, "itemSequenceInfo", "itemSequenceInfo", charset, "itemSequenceInfo")));
        return result;
    }

    private static MessageProcessorInfo createMessageProcessorInfo(MuleDebuggingContext debuggingContext) {
        ComponentLocation componentLocation = debuggingContext.getComponentLocation();
        String identifier = componentLocation.getComponentIdentifier().getIdentifier().getName();
        ArrayList<ObjectFieldDefinition> fields = new ArrayList<ObjectFieldDefinition>();
        debuggingContext.getParameters().values().forEach(processorParameterValue -> {
            String rootSource;
            Class valueType;
            Object value;
            String name = processorParameterValue.parameterName();
            try {
                value = processorParameterValue.resolveValue();
                valueType = value == null ? null : value.getClass();
                rootSource = "SYNTHETIC_OPERATION_ROOT";
            }
            catch (ExpressionRuntimeException expressionRuntimeException) {
                value = expressionRuntimeException.getMessage();
                valueType = ExpressionRuntimeException.class;
                rootSource = "SYNTHETIC_OPERATION_ERROR_ROOT";
            }
            catch (Exception exception) {
                value = exception;
                valueType = exception.getClass();
                rootSource = "SYNTHETIC_OPERATION_ERROR_ROOT";
            }
            FieldPath path = new FieldPath(rootSource).addChild(new FieldNode(name));
            ObjectFieldDefinition parameterDefinition = ObjectFieldDefinitionFactory.createFromObject(value, valueType, name, path, Charset.defaultCharset(), ObjectFieldDefinitionFactory.NULL_DW_ACCESSOR);
            MuleMessageInfoBuilder.setAllReadOnly(parameterDefinition);
            fields.add(parameterDefinition);
        });
        return new MessageProcessorInfo(null, componentLocation.getLocation(), fields, identifier);
    }

    private static void setAllReadOnly(ObjectFieldDefinition parameterDefinition) {
        parameterDefinition.setCanEdit(false);
        parameterDefinition.getInnerElements().forEach(MuleMessageInfoBuilder::setAllReadOnly);
    }

    private static void addPayloadDefinitions(MuleMessageInfo muleMessageInfo, Message message, Charset charset) {
        TypedValue payload = message.getPayload();
        ObjectFieldDefinition payloadDefinition = ObjectFieldDefinitionFactory.createFromObject(payload.getValue(), "payload", "payload", charset, "payload");
        MuleMessageInfoBuilder.addMimeTypeToDefinition(payload, payloadDefinition);
        TypedValue attributes = message.getAttributes();
        ObjectFieldDefinition attributesDefinition = ObjectFieldDefinitionFactory.createFromObject(attributes.getValue(), "attributes", "attributes", charset, "attributes");
        MuleMessageInfoBuilder.addMimeTypeToDefinition(attributes, attributesDefinition);
        muleMessageInfo.addDefinition(payloadDefinition);
        muleMessageInfo.addDefinition(attributesDefinition);
    }

    private static void addVariablesDefinitions(InterceptionEvent interceptionEvent, MuleMessageInfo result) {
        Map variables = interceptionEvent.getVariables();
        ArrayList<ObjectFieldDefinition> collectionOfVariables = new ArrayList<ObjectFieldDefinition>();
        ObjectFieldDefinition varsHolder = new ObjectFieldDefinition("vars", Map.class.getCanonicalName(), "size = " + variables.size(), collectionOfVariables, 0, new FieldPath("vars"), false, "vars");
        int i = 0;
        for (Map.Entry entryElement : variables.entrySet()) {
            String varName = (String)entryElement.getKey();
            TypedValue varTypedValue = (TypedValue)entryElement.getValue();
            Charset charset = MuleMessageInfoBuilder.calculateCharset(varTypedValue.getDataType());
            FieldPath source = MuleMessageInfoBuilder.createVarPath(Integer.toString(i));
            ObjectFieldDefinition variableDefinition = ObjectFieldDefinitionFactory.createFromObject(varTypedValue.getValue(), varName, source, charset, DataWeaveUtils.appendSelector("vars", varName));
            MuleMessageInfoBuilder.addMimeTypeToDefinition(varTypedValue, variableDefinition);
            collectionOfVariables.add(variableDefinition);
            ++i;
        }
        result.addDefinition(varsHolder);
    }

    public static FieldPath createVarPath(String index) {
        FieldPath source = new FieldPath("vars");
        source = source.addChild(new FieldNode(index));
        source = source.addChild(new FieldNode("value"));
        return source;
    }

    public static void addMimeTypeToDefinition(TypedValue typedValue, ObjectFieldDefinition definition) {
        String dwAccessor = MuleMessageInfoBuilder.getMediaTypeDWAccessor(definition);
        ObjectFieldDefinition mimeTypeDefinition = new ObjectFieldDefinition(MEDIA_TYPE_NAME, "", typedValue.getDataType().getMediaType().toRfcString(), new ArrayList<ObjectFieldDefinition>(), 0, new FieldPath(""), false, dwAccessor);
        definition.getInnerElements().add(mimeTypeDefinition);
    }

    public static String getMediaTypeDWAccessor(ObjectFieldDefinition definition) {
        return definition.getDwAccessor() + "." + MEDIA_TYPE_NAME;
    }

    public static Charset calculateCharset(DataType dataType) {
        return dataType.getMediaType().getCharset().orElse(Charset.defaultCharset());
    }

    private static void addErrorDefinition(InterceptionEvent interceptionEvent, MuleMessageInfo result, Charset charset) {
        Optional error = interceptionEvent.getError();
        error.ifPresent(presentError -> result.addDefinition(ObjectFieldDefinitionFactory.createFromObject(presentError, "error", "error", charset, "error")));
    }
}

