/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server;

import com.mulesoft.mule.debugger.commands.ICommand;
import com.mulesoft.mule.debugger.request.IDebuggerRequest;
import com.mulesoft.mule.debugger.response.ErrorResponse;
import com.mulesoft.mule.debugger.response.IDebuggerServerEvent;
import com.mulesoft.mule.debugger.server.BreakpointHandler;
import com.mulesoft.mule.debugger.server.ComponentLocatorProvider;
import com.mulesoft.mule.debugger.server.DebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.server.DebuggerManager;
import com.mulesoft.mule.debugger.server.IDebuggerRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleMessageDebuggerRequestHandler
implements IDebuggerRequestHandler {
    private static final transient Logger logger = LoggerFactory.getLogger((String)MuleMessageDebuggerRequestHandler.class.getName());
    private final ComponentLocatorProvider componentLocatorProvider;
    private final DebuggerManager actionHandler;
    private final DebuggerClientConnectionHandler clientConnectionHandler;
    private final BreakpointHandler breakpointHandler;

    public MuleMessageDebuggerRequestHandler(DebuggerManager actionHandler, DebuggerClientConnectionHandler clientConnectionHandler, BreakpointHandler breakpointHandler, ComponentLocatorProvider componentLocatorProvider) {
        this.actionHandler = actionHandler;
        this.clientConnectionHandler = clientConnectionHandler;
        this.breakpointHandler = breakpointHandler;
        this.componentLocatorProvider = componentLocatorProvider;
    }

    @Override
    public IDebuggerServerEvent handleRequest(IDebuggerRequest request) {
        IDebuggerServerEvent response;
        ICommand command = request.createCommand();
        command.setDebuggerManager(this.actionHandler);
        command.setClientConnectionHandler(this.clientConnectionHandler);
        command.setBreakpointHandler(this.breakpointHandler);
        command.setComponentLocatorProvider(this.componentLocatorProvider);
        try {
            response = command.execute();
        }
        catch (Exception e) {
            logger.error("Exception while executing command", (Throwable)e);
            response = new ErrorResponse("Unexpected error: '" + e.getMessage() + "' while executing command : '" + command.getClass().getName() + "'");
        }
        response.setRequest(request);
        return response;
    }
}

