/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server;

import com.mulesoft.mule.debugger.MuleDebuggingContext;
import com.mulesoft.mule.debugger.response.MuleMessageArrivedEvent;
import com.mulesoft.mule.debugger.server.ComponentLocatorProvider;
import com.mulesoft.mule.debugger.server.DebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.server.DebuggerEventFactory;
import com.mulesoft.mule.debugger.server.DebuggerManager;
import com.mulesoft.mule.debugger.server.EventSender;
import com.mulesoft.mule.debugger.server.ExecutionManager;
import com.mulesoft.mule.debugger.server.ProcessorPath;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MuleExecutionManager
implements ExecutionManager,
EventSender {
    private final DebuggerEventFactory eventFactory;
    private final Object messageProcessed = new Object();
    private final Lock singleMessage = new ReentrantLock(true);
    private ProcessorPath runToProcessor;
    private final DebuggerClientConnectionHandler clientConnectionHandler;
    private final DebuggerManager debuggerManager;
    private MuleDebuggingContext muleDebuggingContext;
    private ComponentLocatorProvider locatorProvider;

    public MuleExecutionManager(DebuggerManager debuggerManager, DebuggerClientConnectionHandler clientConnectionHandler) {
        this.debuggerManager = debuggerManager;
        this.eventFactory = new DebuggerEventFactory();
        this.clientConnectionHandler = clientConnectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        if (this.getDebuggingEvent() != null) {
            this.setRunToProcessor(null);
            this.debuggerManager.setStepping(this.getDebuggingEvent().getInterceptionEvent(), false);
            Object object = this.messageProcessed;
            synchronized (object) {
                this.messageProcessed.notify();
            }
        }
    }

    public MuleDebuggingContext getDebuggingEvent() {
        return this.muleDebuggingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextStep() {
        if (this.getDebuggingEvent() != null) {
            this.debuggerManager.setStepping(this.getDebuggingEvent().getInterceptionEvent(), true);
            Object object = this.messageProcessed;
            synchronized (object) {
                this.messageProcessed.notify();
            }
        }
    }

    @Override
    public void runToLocation(String location) {
        this.setRunToProcessor(new ProcessorPath(location));
        this.nextStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExecution(MuleDebuggingContext debuggingContext, Throwable exception) {
        if (this.debuggerManager.isDebuggingThisMessage(debuggingContext.getIdProvider())) {
            try {
                this.singleMessage.lock();
                this.muleDebuggingContext = debuggingContext;
                this.debuggerManager.setStepping(debuggingContext.getInterceptionEvent(), null);
                this.sendEvent(this.eventFactory.createExceptionThrownEvent(this.muleDebuggingContext, exception));
                try {
                    Object object = this.messageProcessed;
                    synchronized (object) {
                        this.messageProcessed.wait();
                    }
                }
                catch (InterruptedException e) {
                    this.debuggerManager.stopAllDebuggingSessions();
                }
            }
            finally {
                this.singleMessage.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExecution(MuleDebuggingContext debuggingContext) {
        block13: {
            if (this.debuggerManager.isDebuggingThisMessage(debuggingContext.getIdProvider())) {
                if (!this.isApplicationRunning(debuggingContext.getAppName())) {
                    this.debuggerManager.stopAllDebuggingSessions();
                    return;
                }
                try {
                    Object processorPath;
                    this.singleMessage.lock();
                    if (!this.debuggerManager.isDebuggingThisMessage(debuggingContext.getIdProvider())) break block13;
                    if (this.getRunToProcessor() != null) {
                        processorPath = debuggingContext.getMessageProcessorPath();
                        boolean matches = new ProcessorPath((String)processorPath).matches(this.getRunToProcessor());
                        if (!matches) {
                            this.debuggerManager.setStepping(debuggingContext.getInterceptionEvent(), true);
                            return;
                        }
                        this.setRunToProcessor(null);
                    }
                    this.muleDebuggingContext = debuggingContext;
                    this.debuggerManager.setStepping(debuggingContext.getInterceptionEvent(), null);
                    this.sendEvent(this.eventFactory.createMessageArrivedEvent(debuggingContext));
                    try {
                        processorPath = this.messageProcessed;
                        synchronized (processorPath) {
                            this.messageProcessed.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        this.debuggerManager.stopAllDebuggingSessions();
                    }
                }
                finally {
                    this.singleMessage.unlock();
                }
            }
        }
    }

    @Override
    public void sendEvent(MuleMessageArrivedEvent messageArrivedEvent) {
        this.clientConnectionHandler.getClientCommunicationService().sendEvent(messageArrivedEvent);
    }

    private boolean isApplicationRunning(String appName) {
        return this.locatorProvider.getLocator(appName) != null;
    }

    public void setLocatorProvider(ComponentLocatorProvider locatorProvider) {
        this.locatorProvider = locatorProvider;
    }

    private ProcessorPath getRunToProcessor() {
        return this.runToProcessor;
    }

    private void setRunToProcessor(ProcessorPath runToProcessor) {
        this.runToProcessor = runToProcessor;
    }
}

