/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server;

import com.mulesoft.mule.debugger.remote.RemoteDebuggerServer;
import com.mulesoft.mule.debugger.server.BreakpointHandler;
import com.mulesoft.mule.debugger.server.DebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.server.DebuggerClientConnectionHandlerImpl;
import com.mulesoft.mule.debugger.server.DebuggerClientConnectionListener;
import com.mulesoft.mule.debugger.server.DebuggerDeploymentListenerService;
import com.mulesoft.mule.debugger.server.DebuggerEventFactory;
import com.mulesoft.mule.debugger.server.DebuggerManagerImpl;
import com.mulesoft.mule.debugger.server.MuleMessageDebuggerRequestHandler;
import com.mulesoft.mule.debugger.server.MuleNotificationDebuggerHandlerImpl;
import com.mulesoft.mule.debugger.server.MuleNotificationHandler;
import com.mulesoft.mule.runtime.module.plugin.api.MulePlugin;
import com.mulesoft.mule.runtime.module.plugin.api.deployment.DeploymentListenerProvider;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerPlugin
implements MulePlugin,
DeploymentListenerProvider {
    private static final transient Logger logger = LoggerFactory.getLogger((String)DebuggerPlugin.class.getName());
    private DebuggerClientConnectionHandler debuggerClientConnectionHandler;
    private RemoteDebuggerServer remoteDebuggerServer;
    private boolean started;
    private DebuggerDeploymentListenerService debuggerDeploymentListenerService;
    private DeploymentService deploymentService;

    public void dispose() {
        this.debuggerClientConnectionHandler = null;
        this.remoteDebuggerServer = null;
        this.deploymentService = null;
        this.debuggerDeploymentListenerService = null;
    }

    public void initialise() {
        DebuggerEventFactory eventFactory = new DebuggerEventFactory();
        this.debuggerClientConnectionHandler = new DebuggerClientConnectionHandlerImpl(eventFactory);
        this.remoteDebuggerServer = new RemoteDebuggerServer(this.getPort(), this.debuggerClientConnectionHandler);
        final BreakpointHandler breakpointHandler = BreakpointHandler.create(this.debuggerClientConnectionHandler);
        final DebuggerManagerImpl actionHandler = new DebuggerManagerImpl(this.debuggerClientConnectionHandler);
        MuleNotificationHandler notificationHandler = this.getNotificationHandler(breakpointHandler, actionHandler);
        this.debuggerDeploymentListenerService = new DebuggerDeploymentListenerService(notificationHandler);
        actionHandler.setLocatorProvider(this.debuggerDeploymentListenerService);
        this.debuggerClientConnectionHandler.addListener(new DebuggerClientConnectionListener(){

            @Override
            public void onClientConnected() {
                MuleMessageDebuggerRequestHandler muleMessageRequestHandler = new MuleMessageDebuggerRequestHandler(actionHandler, DebuggerPlugin.this.debuggerClientConnectionHandler, breakpointHandler, DebuggerPlugin.this.debuggerDeploymentListenerService);
                DebuggerPlugin.this.debuggerClientConnectionHandler.getClientCommunicationService().setRequestHandler(muleMessageRequestHandler);
            }

            @Override
            public void onClientDisconnected() {
            }
        });
    }

    private MuleNotificationHandler getNotificationHandler(BreakpointHandler breakpointHandler, DebuggerManagerImpl actionHandler) {
        return new MuleNotificationDebuggerHandlerImpl(breakpointHandler, actionHandler, this.debuggerClientConnectionHandler);
    }

    private Integer getPort() {
        return Integer.getInteger("mule.debug.port", 6666);
    }

    public void start() {
        if (this.isEnabled()) {
            this.onMuleStart();
            this.started = true;
        } else {
            logger.info(String.format("Debugger is disabled. To enable use '-D%s=true'", "mule.debug.enable"));
        }
    }

    private boolean isEnabled() {
        return Boolean.getBoolean("mule.debug.enable");
    }

    public void stop() {
        if (this.started) {
            this.onMuleStop();
            this.started = false;
        }
    }

    private void onMuleStop() {
        this.debuggerClientConnectionHandler.disconnectClient();
        this.remoteDebuggerServer.stopServer();
    }

    private void onMuleStart() {
        final CountDownLatch suspendLatch = new CountDownLatch(1);
        boolean suspend = Boolean.getBoolean("mule.debug.suspend");
        logger.info("Suspend property is " + suspend);
        if (suspend) {
            this.debuggerClientConnectionHandler.addListener(new DebuggerClientConnectionListener(){

                @Override
                public void onClientConnected() {
                    suspendLatch.countDown();
                }

                @Override
                public void onClientDisconnected() {
                }
            });
        }
        this.remoteDebuggerServer.startServer();
        if (suspend) {
            try {
                System.out.println("Waiting for debugger client to connect at " + this.getPort());
                suspendLatch.await();
                logger.info("Client connected. Continue with mule launch.");
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting for client to connect", (Throwable)e);
            }
        }
        if (this.deploymentService != null) {
            this.debuggerDeploymentListenerService.start(this.deploymentService);
        }
    }

    public void setWorkingDirectory(File file) {
    }

    public boolean isDisabledOnEnvironment() {
        return !this.isEnabled();
    }

    public DeploymentListener getDeploymentListener() {
        return this.debuggerDeploymentListenerService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }
}

