/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server;

import com.mulesoft.mule.debugger.server.MuleNotificationHandler;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.notification.PipelineMessageNotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerPipelineMessageNotificationListener
implements PipelineMessageNotificationListener {
    private static final transient Logger logger = LoggerFactory.getLogger((String)DebuggerPipelineMessageNotificationListener.class.getName());
    private final MuleNotificationHandler notificationHandler;

    DebuggerPipelineMessageNotificationListener(MuleNotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public void onNotification(Notification notification) {
        Event muleEvent = ((EnrichedServerNotification)notification).getEvent();
        PipelineMessageNotification pipelineMessageNotification = (PipelineMessageNotification)notification;
        if (pipelineMessageNotification.getAction().getActionId() == 1804) {
            if (pipelineMessageNotification.getException() != null) {
                this.notificationHandler.onPipelineCompleteWithExceptionReached(() -> ((Event)muleEvent).getCorrelationId(), pipelineMessageNotification.getException());
            } else {
                logger.debug("Notification " + notification.getAction() + " was received " + muleEvent.getContext().getCorrelationId());
                this.notificationHandler.onPipelineCompleteReached(() -> ((Event)muleEvent).getCorrelationId());
            }
        } else if (pipelineMessageNotification.getAction().getActionId() == 1801) {
            logger.debug("Notification " + notification.getAction() + " was received " + muleEvent.getContext().getCorrelationId());
            this.notificationHandler.onPipelineStartReached(() -> ((Event)muleEvent).getCorrelationId());
        }
    }
}

