/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server;

import com.mulesoft.mule.debugger.server.ComponentLocatorProvider;
import com.mulesoft.mule.debugger.server.CorrelationIdProvider;
import com.mulesoft.mule.debugger.server.DebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.server.DebuggerClientConnectionListener;
import com.mulesoft.mule.debugger.server.DebuggerManager;
import com.mulesoft.mule.debugger.server.ExecutionManager;
import com.mulesoft.mule.debugger.server.MuleExecutionManager;
import com.mulesoft.mule.debugger.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.runtime.api.interception.InterceptionEvent;

public class DebuggerManagerImpl
implements DebuggerManager {
    private static final String WAITING = "WAITING";
    private final MuleExecutionManager muleExecutionManager;
    private String stepping;
    private AtomicReference<Pair<InterceptionEvent, ? extends ExecutionManager>> debuggingMessage = new AtomicReference();
    private Map<String, BlockingQueue<String>> debuggingMessageQueue = new HashMap<String, BlockingQueue<String>>();
    private ReentrantLock singleProcessor = new ReentrantLock(true);

    public DebuggerManagerImpl(DebuggerClientConnectionHandler clientConnectionHandler) {
        this.muleExecutionManager = new MuleExecutionManager(this, clientConnectionHandler);
        clientConnectionHandler.addListener(new DebuggerClientConnectionListener(){

            @Override
            public void onClientConnected() {
            }

            @Override
            public void onClientDisconnected() {
                DebuggerManagerImpl.this.stopAllDebuggingSessions();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopDebugging() {
        AtomicReference<Pair<InterceptionEvent, ? extends ExecutionManager>> atomicReference = this.debuggingMessage;
        synchronized (atomicReference) {
            if (this.debuggingMessage.get() != null) {
                this.debuggingMessageQueue.remove(this.debuggingMessage.get().getLeft().getCorrelationId());
                this.debuggingMessage.set(null);
                this.debuggingMessage.notifyAll();
            }
        }
    }

    @Override
    public void stopAllDebuggingSessions() {
        this.stopDebugging();
    }

    public InterceptionEvent getDebuggingMessage() {
        return this.debuggingMessage.get() == null ? null : this.debuggingMessage.get().getLeft();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDebuggingThisMessage(CorrelationIdProvider event) {
        AtomicReference<Pair<InterceptionEvent, ? extends ExecutionManager>> atomicReference = this.debuggingMessage;
        synchronized (atomicReference) {
            return this.debuggingMessage.get() == null ? false : this.debuggingMessage.get().getLeft().getCorrelationId().equals(event.getCorrelationId());
        }
    }

    @Override
    public ExecutionManager getCurrentExecutionManager() {
        return this.debuggingMessage.get() == null ? null : this.debuggingMessage.get().getRight();
    }

    @Override
    public MuleExecutionManager getMuleExecutionManager() {
        return this.muleExecutionManager;
    }

    @Override
    public void startDebugging(InterceptionEvent notification) {
        this.startDebugging(notification, this.muleExecutionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDebugging(InterceptionEvent notification, ExecutionManager executionManager) {
        AtomicReference<Pair<InterceptionEvent, ? extends ExecutionManager>> atomicReference = this.debuggingMessage;
        synchronized (atomicReference) {
            while (!this.isDebuggingThisMessage(() -> ((InterceptionEvent)notification).getCorrelationId()) && !this.debuggingMessage.compareAndSet(null, new Pair<InterceptionEvent, ExecutionManager>(notification, executionManager))) {
                try {
                    this.debuggingMessage.wait();
                }
                catch (InterruptedException e) {
                    this.stopAllDebuggingSessions();
                }
            }
        }
    }

    public void setLocatorProvider(ComponentLocatorProvider locatorProvider) {
        this.muleExecutionManager.setLocatorProvider(locatorProvider);
    }

    @Override
    public void setStepping(InterceptionEvent interceptionEvent, Boolean stepping) {
        this.singleProcessor.lock();
        try {
            if (stepping == null) {
                this.stepping = WAITING;
            } else {
                this.stepping = stepping != false ? interceptionEvent.getCorrelationId() : null;
                this.debuggingMessageQueue.putIfAbsent(interceptionEvent.getCorrelationId(), new ArrayBlockingQueue(1, true));
                this.debuggingMessageQueue.get(interceptionEvent.getCorrelationId()).poll();
            }
        }
        finally {
            this.singleProcessor.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean isStepping(CorrelationIdProvider provider) {
        Object object;
        try {
            object = this.debuggingMessageQueue;
            synchronized (object) {
                this.debuggingMessageQueue.putIfAbsent(provider.getCorrelationId(), new ArrayBlockingQueue(1, true));
                this.debuggingMessageQueue.get(provider.getCorrelationId()).put(provider.getCorrelationId());
            }
        }
        catch (InterruptedException e) {
            this.stopAllDebuggingSessions();
            return false;
        }
        this.singleProcessor.lock();
        try {
            object = this.stepping != null && this.stepping.equals(provider.getCorrelationId());
            return object;
        }
        finally {
            this.singleProcessor.unlock();
        }
    }
}

