/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server;

import com.mulesoft.mule.debugger.MuleDebuggingContext;
import com.mulesoft.mule.debugger.server.MuleNotificationHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerInterceptor
implements ProcessorInterceptor {
    private final MuleExpressionLanguage evaluator;
    private final TransformationService transformationService;
    private final MuleNotificationHandler notificationHandler;
    private static final transient Logger logger = LoggerFactory.getLogger((String)DebuggerInterceptor.class.getName());
    private final String appName;
    private Map<String, ProcessorParameterValue> parameters;

    public DebuggerInterceptor(String appName, MuleExpressionLanguage expressionEvaluator, TransformationService transformationService, MuleNotificationHandler notificationHandler) {
        this.evaluator = expressionEvaluator;
        this.transformationService = transformationService;
        this.notificationHandler = notificationHandler;
        this.appName = appName;
        this.parameters = new HashMap<String, ProcessorParameterValue>();
    }

    public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
        logger.debug("Before invoking message processor -> Path :" + location.getLocation());
        this.parameters = parameters;
        this.notificationHandler.onMuleMessageArrived(this.createMuleDebuggingEvent(this.evaluator, event, location, this.transformationService, parameters));
    }

    public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
        logger.debug("After invoking message processor -> Path :" + location.getLocation());
        if (thrown.isPresent()) {
            this.notificationHandler.onExceptionThrown(this.createMuleDebuggingEvent(this.evaluator, event, location, this.transformationService, this.parameters), thrown.get());
        } else {
            this.notificationHandler.onMuleMessageLeft(this.createMuleDebuggingEvent(this.evaluator, event, location, this.transformationService));
        }
    }

    private MuleDebuggingContext createMuleDebuggingEvent(MuleExpressionLanguage evaluator, InterceptionEvent interceptionEvent, ComponentLocation componentLocation, TransformationService transformationService) {
        return new MuleDebuggingContext(evaluator, interceptionEvent, componentLocation, this.appName, transformationService);
    }

    private MuleDebuggingContext createMuleDebuggingEvent(MuleExpressionLanguage evaluator, InterceptionEvent interceptionEvent, ComponentLocation componentLocation, TransformationService transformationService, Map<String, ProcessorParameterValue> parameters) {
        return new MuleDebuggingContext(evaluator, interceptionEvent, componentLocation, this.appName, transformationService, parameters);
    }
}

