/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server;

import com.mulesoft.mule.debugger.server.ComponentLocatorProvider;
import com.mulesoft.mule.debugger.server.DebuggerMuleNotificationHandler;
import com.mulesoft.mule.debugger.server.DebuggerMuleNotificationHandlerFactory;
import com.mulesoft.mule.debugger.server.DebuggerMuleNotificationHandlerFactoryImpl;
import com.mulesoft.mule.debugger.server.MuleNotificationHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;

public class DebuggerDeploymentListenerService
implements DeploymentListener,
ComponentLocatorProvider {
    private final MuleNotificationHandler notificationHandler;
    private final Map<String, DebuggerMuleNotificationHandler> handlersByAppName;
    private final Map<String, ConfigurationComponentLocator> configurationLocatorMap;
    private DebuggerMuleNotificationHandlerFactory muleNotificationHandlerFactory = new DebuggerMuleNotificationHandlerFactoryImpl();

    public DebuggerDeploymentListenerService(MuleNotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
        this.handlersByAppName = new HashMap<String, DebuggerMuleNotificationHandler>();
        this.configurationLocatorMap = new HashMap<String, ConfigurationComponentLocator>();
    }

    public void onDeploymentStart(String artifactName) {
    }

    public void onDeploymentFailure(String appName, Throwable throwable) {
        this.unregisterApplication(appName);
    }

    public void onUndeploymentStart(String appName) {
        this.unregisterApplication(appName);
    }

    public void onArtifactCreated(String artifactName, CustomizationService customizationService) {
        this.registerApplication(artifactName, customizationService);
    }

    public void onArtifactInitialised(String artifactName, Registry registry) {
        Optional configurationComponentLocator = registry.lookupByType(ConfigurationComponentLocator.class);
        configurationComponentLocator.ifPresent(componentLocator -> this.configurationLocatorMap.put(artifactName, (ConfigurationComponentLocator)componentLocator));
    }

    private void registerApplication(String appName, CustomizationService muleContext) {
        DebuggerMuleNotificationHandler debuggerMuleNotificationHandler = this.muleNotificationHandlerFactory.create(this.notificationHandler, appName, muleContext);
        debuggerMuleNotificationHandler.start();
        this.handlersByAppName.put(appName, debuggerMuleNotificationHandler);
    }

    private void unRegisterAllApplications() {
        Set<String> appNames = this.handlersByAppName.keySet();
        for (String appName : appNames) {
            this.unregisterApplication(appName);
        }
    }

    public void start(DeploymentService deploymentService) {
        List applications = deploymentService.getApplications();
        for (Application application : applications) {
            this.registerApplication(application.getArtifactName(), (CustomizationService)application.getRegistry().lookupByType(CustomizationService.class).get());
        }
    }

    public void stop() {
        this.unRegisterAllApplications();
    }

    public void setMuleNotificationHandlerFactory(DebuggerMuleNotificationHandlerFactory muleNotificationHandlerFactory) {
        if (muleNotificationHandlerFactory == null) {
            throw new IllegalArgumentException("muleNotificationHandlerFactory argument can not be null");
        }
        this.muleNotificationHandlerFactory = muleNotificationHandlerFactory;
    }

    private void unregisterApplication(String appName) {
        if (this.handlersByAppName.containsKey(appName)) {
            this.handlersByAppName.get(appName).stop();
            this.handlersByAppName.remove(appName);
        }
        this.configurationLocatorMap.remove(appName);
        this.notificationHandler.onApplicationDown(appName);
    }

    @Override
    public ConfigurationComponentLocator getLocator(String appName) {
        return this.configurationLocatorMap.get(appName);
    }
}

