/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server;

import com.mulesoft.mule.debugger.server.ClientCommunicationService;
import com.mulesoft.mule.debugger.server.DebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.server.DebuggerClientConnectionListener;
import com.mulesoft.mule.debugger.server.DebuggerEventFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DebuggerClientConnectionHandlerImpl
implements DebuggerClientConnectionHandler {
    private final Lock singleClient = new ReentrantLock();
    private final List<DebuggerClientConnectionListener> listeners;
    private final DebuggerEventFactory debuggerFactory;
    private ClientCommunicationService communicationService;

    public DebuggerClientConnectionHandlerImpl(DebuggerEventFactory debuggerFactory) {
        this.debuggerFactory = debuggerFactory;
        this.listeners = new ArrayList<DebuggerClientConnectionListener>();
    }

    @Override
    public void addListener(DebuggerClientConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public ClientCommunicationService getClientCommunicationService() {
        return this.communicationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectClient(ClientCommunicationService communicationService) {
        if (this.singleClient.tryLock()) {
            try {
                this.communicationService = communicationService;
                for (DebuggerClientConnectionListener listener : this.listeners) {
                    listener.onClientConnected();
                }
                this.communicationService.sendEvent(this.debuggerFactory.createConnectionEstablishedEvent());
                this.communicationService.start();
            }
            finally {
                this.singleClient.unlock();
            }
        }
    }

    @Override
    public boolean isClientConnected() {
        return this.communicationService != null;
    }

    @Override
    public void disconnectClient() {
        if (!this.isClientConnected()) {
            return;
        }
        for (DebuggerClientConnectionListener listener : this.listeners) {
            listener.onClientDisconnected();
        }
        this.communicationService.stop();
        this.communicationService = null;
    }
}

