/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server;

import com.mulesoft.mule.debugger.request.IDebuggerRequest;
import com.mulesoft.mule.debugger.response.IDebuggerServerEvent;
import com.mulesoft.mule.debugger.server.IDebuggerRequestHandler;
import com.mulesoft.mule.debugger.transport.IServerDebuggerProtocol;

public class ClientCommunicationService {
    private IDebuggerRequestHandler requestHandler;
    private volatile boolean keepRunning = true;
    private final IServerDebuggerProtocol protocol;

    public ClientCommunicationService(IServerDebuggerProtocol protocol) {
        this.protocol = protocol;
    }

    public void start() {
        while (this.keepRunning) {
            IDebuggerRequest request = this.protocol.getRequest();
            if (this.requestHandler == null) continue;
            IDebuggerServerEvent response = this.requestHandler.handleRequest(request);
            this.protocol.sendResponse(response);
        }
    }

    public void sendEvent(IDebuggerServerEvent response) {
        this.protocol.sendResponse(response);
    }

    public boolean isRunning() {
        return this.keepRunning;
    }

    public void setRequestHandler(IDebuggerRequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    public void stop() {
        this.keepRunning = false;
    }
}

