/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.response;

import com.mulesoft.mule.debugger.response.FieldNode;
import com.mulesoft.mule.debugger.response.ObjectFieldDefinitionFactory;
import com.mulesoft.mule.debugger.util.DataWeaveUtils;
import com.mulesoft.mule.debugger.util.ReflectionUtils;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;

public class FieldPathAccessor {
    public static Optional<Object> update(Iterator<FieldNode> children, Object toUpdate, Object newValue) throws IllegalAccessException {
        return FieldPathAccessor.update(children, toUpdate, newValue, Optional.empty(), Optional.empty());
    }

    public static Optional<Object> update(Iterator<FieldNode> children, Object toUpdate, Object newValue, Optional<Field> parentField, Optional<Object> parentObject) throws IllegalAccessException {
        FieldNode path = children.next();
        Class<?> toUpdateClass = toUpdate.getClass();
        if (toUpdateClass.isArray()) {
            int index = Integer.parseInt(path.getName());
            if (!children.hasNext()) {
                Array.set(toUpdate, index, newValue);
            } else {
                Object childObject = Array.get(toUpdate, index);
                FieldPathAccessor.update(children, childObject, newValue, Optional.empty(), Optional.of(toUpdate));
            }
        } else if (Collection.class.isAssignableFrom(toUpdateClass)) {
            Collection collection = (Collection)toUpdate;
            int index = Integer.parseInt(path.getName());
            if (!children.hasNext()) {
                if (List.class.isAssignableFrom(toUpdateClass)) {
                    List list = (List)toUpdate;
                    list.set(index, newValue);
                } else {
                    Object[] objects = collection.toArray();
                    collection.clear();
                    objects[index] = newValue;
                    collection.addAll(Arrays.asList(objects));
                }
            } else {
                Object[] objects = collection.toArray();
                FieldPathAccessor.update(children, objects[index], newValue, Optional.empty(), Optional.of(toUpdate));
            }
        } else if (Map.class.isAssignableFrom(toUpdateClass)) {
            int index = Integer.parseInt(path.getName());
            Map map = (Map)toUpdate;
            LinkedHashMap<Object, Object> newMap = new LinkedHashMap<Object, Object>();
            FieldNode mapChild = children.next();
            Set entries = map.entrySet();
            int i = 0;
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry mapEntry = entry = iterator.next();
                newMap.put(mapEntry.getKey(), mapEntry.getValue());
                if (i == index) {
                    if (mapChild.getName().equals("value")) {
                        if (children.hasNext()) {
                            Object toUpdateWithoutTypedValue = mapEntry.getValue() instanceof TypedValue ? ((TypedValue)mapEntry.getValue()).getValue() : mapEntry.getValue();
                            Optional<Object> value = FieldPathAccessor.update(children, toUpdateWithoutTypedValue, newValue, Optional.empty(), Optional.of(toUpdate));
                            value.ifPresent(object -> newMap.put(mapEntry.getKey(), object));
                        } else {
                            newMap.put(mapEntry.getKey(), newValue);
                        }
                    } else if (children.hasNext()) {
                        FieldPathAccessor.update(children, mapEntry.getKey(), newValue, Optional.empty(), Optional.of(toUpdate));
                    } else {
                        newMap.remove(mapEntry.getKey());
                        newMap.put(newValue, mapEntry.getValue());
                    }
                }
                ++i;
            }
            if (!parentField.isPresent() || !parentObject.isPresent()) {
                return Optional.of(Collections.unmodifiableMap(newMap));
            }
            parentField.get().set(parentObject.get(), Collections.unmodifiableMap(newMap));
        } else {
            Field field = ReflectionUtils.searchField(toUpdateClass, path.getName());
            if (field == null) {
                throw new RuntimeException("Invalid attribute name :'" + path.getName() + "'");
            }
            field.setAccessible(true);
            if (!children.hasNext()) {
                field.set(toUpdate, newValue);
            } else {
                Object childObject = field.get(toUpdate);
                FieldPathAccessor.update(children, childObject, newValue, Optional.of(field), Optional.of(toUpdate));
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object get(Iterator<FieldNode> children, Object queryObject) throws IllegalAccessException {
        if (!children.hasNext()) return queryObject;
        if (queryObject == null) {
            return queryObject;
        }
        FieldNode path = children.next();
        Class<?> toUpdateClass = queryObject.getClass();
        if (toUpdateClass.isArray()) {
            int index = Integer.parseInt(path.getName());
            Object childObject = Array.get(queryObject, index);
            return FieldPathAccessor.get(children, childObject);
        }
        if (Collection.class.isAssignableFrom(toUpdateClass)) {
            Collection collection = (Collection)queryObject;
            int index = Integer.parseInt(path.getName());
            Object[] objects = collection.toArray();
            return FieldPathAccessor.get(children, objects[index]);
        }
        if (!Map.class.isAssignableFrom(toUpdateClass)) {
            if (queryObject instanceof CursorIteratorProvider) {
                CursorIteratorProvider cursorIteratorProvider = (CursorIteratorProvider)queryObject;
                int index = Integer.parseInt(path.getName());
                try (CursorIterator cursor = (CursorIterator)cursorIteratorProvider.openCursor();){
                    int position = 0;
                    while (cursor.hasNext()) {
                        Object nextItem = cursor.next();
                        if (position == index) {
                            Object object = FieldPathAccessor.get(children, nextItem);
                            return object;
                        }
                        ++position;
                    }
                    return queryObject;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return queryObject;
                }
            }
            Field field = ReflectionUtils.searchField(toUpdateClass, path.getName());
            if (field == null) {
                throw new RuntimeException("Invalid attribute name :'" + path.getName() + "'");
            }
            field.setAccessible(true);
            Object childObject = field.get(queryObject);
            return FieldPathAccessor.get(children, childObject);
        }
        int index = Integer.parseInt(path.getName());
        Map map = (Map)queryObject;
        FieldNode mapChild = children.next();
        Set entries = map.entrySet();
        int i = 0;
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (i == index) {
                Map.Entry mapEntry = entry;
                if (!mapChild.getName().equals("value")) return FieldPathAccessor.get(children, mapEntry.getKey());
                Object toUpdateWithoutTypedValue = mapEntry.getValue() instanceof TypedValue ? ((TypedValue)mapEntry.getValue()).getValue() : mapEntry.getValue();
                return FieldPathAccessor.get(children, toUpdateWithoutTypedValue);
            }
            ++i;
        }
        return queryObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDWAccessor(Iterator<FieldNode> children, Object queryObject, String suffixExpression) throws IllegalAccessException {
        if (!children.hasNext()) {
            return suffixExpression;
        }
        FieldNode path = children.next();
        Class<?> toUpdateClass = queryObject.getClass();
        if (toUpdateClass.isArray()) {
            int index = Integer.parseInt(path.getName());
            Object childObject = Array.get(queryObject, index);
            return FieldPathAccessor.getDWAccessor(children, childObject, DataWeaveUtils.appendIndex(suffixExpression, index));
        }
        if (Collection.class.isAssignableFrom(toUpdateClass)) {
            Collection collection = (Collection)queryObject;
            int index = Integer.parseInt(path.getName());
            Object[] objects = collection.toArray();
            return FieldPathAccessor.getDWAccessor(children, objects[index], DataWeaveUtils.appendIndex(suffixExpression, index));
        }
        if (!Map.class.isAssignableFrom(toUpdateClass)) {
            if (queryObject instanceof CursorIteratorProvider) {
                CursorIteratorProvider cursorIteratorProvider = (CursorIteratorProvider)queryObject;
                int index = Integer.parseInt(path.getName());
                try (CursorIterator cursor = (CursorIterator)cursorIteratorProvider.openCursor();){
                    int position = 0;
                    while (cursor.hasNext()) {
                        Object nextItem = cursor.next();
                        if (position == index) {
                            String string = FieldPathAccessor.getDWAccessor(children, nextItem, DataWeaveUtils.appendIndex(suffixExpression, index));
                            return string;
                        }
                        ++position;
                    }
                    return suffixExpression;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return suffixExpression;
                }
            }
            Field field = ReflectionUtils.searchField(toUpdateClass, path.getName());
            if (field == null) {
                throw new RuntimeException("Invalid attribute name :'" + path.getName() + "'");
            }
            field.setAccessible(true);
            Object childObject = field.get(queryObject);
            return FieldPathAccessor.getDWAccessor(children, childObject, DataWeaveUtils.appendSelector(suffixExpression, path.getName()));
        }
        int index = Integer.parseInt(path.getName());
        Map map = (Map)queryObject;
        FieldNode mapChild = children.next();
        Set entries = map.entrySet();
        int i = 0;
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (i == index) {
                Map.Entry mapEntry = entry;
                if (!mapChild.getName().equals("value")) return ObjectFieldDefinitionFactory.NULL_DW_ACCESSOR;
                Object toUpdateWithoutTypedValue = mapEntry.getValue() instanceof TypedValue ? ((TypedValue)mapEntry.getValue()).getValue() : mapEntry.getValue();
                return FieldPathAccessor.getDWAccessor(children, toUpdateWithoutTypedValue, DataWeaveUtils.appendSelector(suffixExpression, mapEntry.getKey(), i));
            }
            ++i;
        }
        return suffixExpression;
    }
}

