/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.response;

import com.mulesoft.mule.debugger.response.FieldNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class FieldPath
implements Serializable {
    public static final String PATH_SEPARATOR = "/";
    private static final long serialVersionUID = 3147795132969576366L;
    private final String rootExpression;
    private final ArrayList<FieldNode> orderedPathElements;

    public FieldPath(String rootExpression) {
        this.rootExpression = rootExpression;
        this.orderedPathElements = new ArrayList();
    }

    public FieldPath(String rootExpression, ArrayList<FieldNode> orderedPathElements) {
        this.rootExpression = rootExpression;
        this.orderedPathElements = orderedPathElements;
    }

    public String getRootExpression() {
        return this.rootExpression;
    }

    public List<FieldNode> getOrderedPathElements() {
        return this.orderedPathElements;
    }

    public FieldPath addChild(FieldNode child) {
        ArrayList<FieldNode> fieldNodePaths = new ArrayList<FieldNode>(this.orderedPathElements);
        fieldNodePaths.add(child);
        return new FieldPath(this.rootExpression, fieldNodePaths);
    }

    public String toString() {
        return "FieldPath{name='" + this.rootExpression + '\'' + ", orderedPathElements=" + this.orderedPathElements + '}';
    }

    public static FieldPath fromString(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, PATH_SEPARATOR);
        FieldPath result = null;
        while (tokenizer.hasMoreTokens()) {
            if (result == null) {
                result = new FieldPath(tokenizer.nextToken());
                continue;
            }
            result = result.addChild(new FieldNode(tokenizer.nextToken()));
        }
        return result;
    }
}

