/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.remote;

import com.mulesoft.mule.debugger.response.ErrorResponse;
import com.mulesoft.mule.debugger.server.ClientCommunicationService;
import com.mulesoft.mule.debugger.server.DebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.transport.SerializeDebuggerProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDebuggerSession
implements Runnable {
    protected final Socket clientSocket;
    protected final String serverText;
    private final DebuggerClientConnectionHandler clientConnectionHandler;
    private static final transient Logger logger = LoggerFactory.getLogger((String)RemoteDebuggerSession.class.getName());

    public RemoteDebuggerSession(Socket clientSocket, String serverText, DebuggerClientConnectionHandler clientConnectionHandler) {
        this.clientSocket = clientSocket;
        this.serverText = serverText;
        this.clientConnectionHandler = clientConnectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream input = null;
        OutputStream output = null;
        try {
            input = this.clientSocket.getInputStream();
            output = this.clientSocket.getOutputStream();
            SerializeDebuggerProtocol protocol = new SerializeDebuggerProtocol(input, output);
            if (!this.clientConnectionHandler.isClientConnected()) {
                this.clientConnectionHandler.connectClient(new ClientCommunicationService(protocol));
            } else {
                protocol.sendResponse(new ErrorResponse("I can not attend you right now someone else is already connected. Try later!"));
            }
        }
        catch (IOException e) {
            logger.error("Exception while connecting to client", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.error("Exception while closing stream", (Throwable)e);
                }
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    logger.error("Exception while closing stream", (Throwable)e);
                }
            }
            try {
                this.clientSocket.close();
            }
            catch (IOException e) {
                logger.error("Exception while closing socket", (Throwable)e);
            }
        }
    }
}

