/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.remote;

import com.mulesoft.mule.debugger.remote.RemoteDebuggerSession;
import com.mulesoft.mule.debugger.server.DebuggerClientConnectionHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDebuggerServer
extends Thread {
    private final int serverPort;
    private final DebuggerClientConnectionHandler connectionHandler;
    private ServerSocket serverSocket = null;
    private volatile boolean isStopped = false;
    private final ExecutorService threadPool = Executors.newFixedThreadPool(1);
    private static final transient Logger logger = LoggerFactory.getLogger((String)RemoteDebuggerServer.class.getName());

    public RemoteDebuggerServer(int port, DebuggerClientConnectionHandler connectionHandler) {
        this.serverPort = port;
        this.connectionHandler = connectionHandler;
    }

    @Override
    public void run() {
        logger.info("Server starting at " + this.serverPort);
        this.createServerSocket();
        try {
            while (!this.isStopped()) {
                try {
                    Socket clientSocket = this.serverSocket.accept();
                    this.threadPool.execute(new RemoteDebuggerSession(clientSocket, "Console Session", this.connectionHandler));
                }
                catch (IOException e) {
                    this.stopServer();
                }
            }
        }
        finally {
            this.threadPool.shutdown();
            if (!this.serverSocket.isClosed()) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing server", e);
                }
            }
        }
        logger.info("Server stopped");
    }

    private synchronized boolean isStopped() {
        return this.isStopped;
    }

    public void startServer() {
        this.start();
    }

    public void stopServer() {
        try {
            this.isStopped = true;
            this.threadPool.shutdownNow();
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing server", e);
        }
    }

    private void createServerSocket() {
        try {
            this.serverSocket = new ServerSocket(this.serverPort);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot open port " + this.serverPort, e);
        }
    }
}

