/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.commons;

import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.response.IDebuggerServerEvent;
import com.mulesoft.mule.debugger.response.SchedulerCommandExceptionResponse;
import com.mulesoft.mule.debugger.response.SchedulerStartResponse;
import com.mulesoft.mule.debugger.response.SchedulerStopResponse;
import com.mulesoft.mule.debugger.response.SchedulerTriggerResponse;
import java.util.List;
import org.mule.runtime.api.source.SchedulerMessageSource;

public enum SchedulerAction {
    START(schedulers -> {
        try {
            for (SchedulerMessageSource scheduler : schedulers) {
                scheduler.start();
            }
            return new SchedulerStartResponse();
        }
        catch (Exception e) {
            return new SchedulerCommandExceptionResponse(new RemoteDebugException(e.getMessage(), e));
        }
    }),
    STOP(schedulers -> {
        try {
            for (SchedulerMessageSource scheduler : schedulers) {
                scheduler.stop();
            }
            return new SchedulerStopResponse();
        }
        catch (Exception e) {
            return new SchedulerCommandExceptionResponse(new RemoteDebugException(e.getMessage(), e));
        }
    }),
    TRIGGER(schedulers -> {
        try {
            for (SchedulerMessageSource scheduler : schedulers) {
                scheduler.trigger();
            }
            return new SchedulerTriggerResponse();
        }
        catch (Exception e) {
            return new SchedulerCommandExceptionResponse(new RemoteDebugException(e.getMessage(), e));
        }
    });

    private final ActionExecutor actionExecutor;

    private SchedulerAction(ActionExecutor actionExecutor) {
        this.actionExecutor = actionExecutor;
    }

    public IDebuggerServerEvent executeOver(List<SchedulerMessageSource> schedulers) {
        return this.actionExecutor.execute(schedulers);
    }

    private static interface ActionExecutor {
        public IDebuggerServerEvent execute(List<SchedulerMessageSource> var1);
    }
}

