/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.commands;

import com.mulesoft.mule.debugger.MuleDebuggingContext;
import com.mulesoft.mule.debugger.commands.AbstractCommand;
import com.mulesoft.mule.debugger.commands.UpdaterUtils;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.response.FieldNode;
import com.mulesoft.mule.debugger.response.FieldPath;
import com.mulesoft.mule.debugger.response.FieldPathAccessor;
import com.mulesoft.mule.debugger.response.IDebuggerServerEvent;
import com.mulesoft.mule.debugger.response.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.response.ObjectFieldDefinitionFactory;
import com.mulesoft.mule.debugger.response.ScriptExceptionResponse;
import com.mulesoft.mule.debugger.response.UpdatedFieldResponse;
import com.mulesoft.mule.debugger.server.MuleMessageInfoBuilder;
import com.mulesoft.mule.debugger.util.FieldUpdater;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.metadata.TypedValue;

public class UpdateFieldCommand
extends AbstractCommand {
    private final FieldPath fieldPath;
    private final String script;

    public UpdateFieldCommand(FieldPath path, String newValue) {
        this.fieldPath = path;
        this.script = newValue;
    }

    @Override
    public IDebuggerServerEvent execute() {
        MuleDebuggingContext debuggingMessage = this.getMuleDebuggingMessage();
        String rootElementScript = this.fieldPath.getRootExpression();
        FieldUpdater updater = UpdaterUtils.getUpdaterFor(this.fieldPath);
        try {
            ObjectFieldDefinition fieldDefinition;
            TypedValue rootElement = debuggingMessage.evaluateExpression(rootElementScript);
            TypedValue typedValue = debuggingMessage.evaluateExpression(this.script);
            List<FieldNode> orderedPathElements = this.fieldPath.getOrderedPathElements();
            if (orderedPathElements.isEmpty()) {
                fieldDefinition = ObjectFieldDefinitionFactory.createFromObject(typedValue.getValue(), rootElementScript, this.fieldPath, debuggingMessage.getCharset(), rootElementScript);
                updater.update(debuggingMessage, typedValue.getValue());
            } else {
                Optional<Object> updatedRoot = FieldPathAccessor.update(orderedPathElements.iterator(), rootElement.getValue(), typedValue.getValue(), Optional.empty(), Optional.empty());
                Object result = FieldPathAccessor.get(orderedPathElements.iterator(), updatedRoot.orElseGet(() -> ((TypedValue)rootElement).getValue()));
                String dwAccessor = FieldPathAccessor.getDWAccessor(orderedPathElements.iterator(), updatedRoot.orElseGet(() -> ((TypedValue)rootElement).getValue()), rootElementScript);
                if (result instanceof TypedValue) {
                    result = ((TypedValue)result).getValue();
                }
                fieldDefinition = ObjectFieldDefinitionFactory.createFromObject(result, orderedPathElements.get(orderedPathElements.size() - 1).getName(), this.fieldPath, debuggingMessage.getCharset(), dwAccessor);
                if (updatedRoot.isPresent()) {
                    updater.update(debuggingMessage, updatedRoot.get());
                } else {
                    updater.update(debuggingMessage, rootElement.getValue());
                }
            }
            if (rootElementScript.equals("payload") || rootElementScript.equals("vars")) {
                MuleMessageInfoBuilder.addMimeTypeToDefinition(typedValue, fieldDefinition);
            }
            return new UpdatedFieldResponse(fieldDefinition);
        }
        catch (Exception e) {
            return new ScriptExceptionResponse(new RemoteDebugException(e.getMessage(), e));
        }
    }
}

