/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.commands;

import com.mulesoft.mule.debugger.commands.AbstractCommand;
import com.mulesoft.mule.debugger.commons.SchedulerAction;
import com.mulesoft.mule.debugger.response.ErrorResponse;
import com.mulesoft.mule.debugger.response.IDebuggerServerEvent;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.source.SchedulerMessageSource;

public class SchedulerCommand
extends AbstractCommand {
    private final String flow;
    private final SchedulerAction action;
    private final String appName;
    private final boolean applyToAll;

    public SchedulerCommand(String appName, String flow, SchedulerAction action, boolean applyToAll) {
        this.appName = appName;
        this.flow = flow;
        this.action = action;
        this.applyToAll = applyToAll;
    }

    @Override
    public IDebuggerServerEvent execute() {
        try {
            ConfigurationComponentLocator locator = this.getComponentLocatorProvider().getLocator(this.appName);
            List possibleSchedulers = locator.find(ComponentIdentifier.buildFromStringRepresentation((String)"mule:scheduler"));
            Stream<Object> flowConstructStream = possibleSchedulers.stream();
            if (!this.applyToAll) {
                flowConstructStream = flowConstructStream.filter(messageSource -> ((LocationPart)messageSource.getLocation().getParts().get(0)).getPartPath().equals(this.flow));
            }
            Stream<SchedulerMessageSource> schedulerMessageSourceStream = flowConstructStream.filter(messageSource -> messageSource instanceof SchedulerMessageSource).map(messageSource -> (SchedulerMessageSource)messageSource);
            return this.action.executeOver(schedulerMessageSourceStream.collect(Collectors.toList()));
        }
        catch (Exception e) {
            return new ErrorResponse(e.getMessage());
        }
    }
}

