/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.commands;

import com.mulesoft.mule.debugger.MuleDebuggingContext;
import com.mulesoft.mule.debugger.commands.AbstractCommand;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.response.FieldNode;
import com.mulesoft.mule.debugger.response.FieldPath;
import com.mulesoft.mule.debugger.response.FieldPathAccessor;
import com.mulesoft.mule.debugger.response.IDebuggerServerEvent;
import com.mulesoft.mule.debugger.response.LoadInnerFieldsResponse;
import com.mulesoft.mule.debugger.response.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.response.ObjectFieldDefinitionFactory;
import com.mulesoft.mule.debugger.response.ScriptExceptionResponse;
import com.mulesoft.mule.debugger.server.MuleMessageInfoBuilder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadInnerFieldsCommand
extends AbstractCommand {
    private final FieldPath fieldPath;
    private static final transient Logger logger = LoggerFactory.getLogger(LoadInnerFieldsCommand.class);

    public LoadInnerFieldsCommand(FieldPath fieldPath) {
        this.fieldPath = fieldPath;
    }

    @Override
    public IDebuggerServerEvent execute() {
        MuleDebuggingContext debuggingMessage = this.getMuleDebuggingMessage();
        String script = this.fieldPath.getRootExpression();
        try {
            Charset charset;
            List<FieldNode> orderedPathElements;
            Object rootElement;
            logger.debug("Load Inner Fields From: " + this.fieldPath);
            if ("SYNTHETIC_OPERATION_ROOT".equals(script) || "SYNTHETIC_OPERATION_ERROR_ROOT".equals(script)) {
                FieldNode fieldNode = this.fieldPath.getOrderedPathElements().get(0);
                ProcessorParameterValue processorParameterValue = debuggingMessage.getParameters().get(fieldNode.getName());
                try {
                    rootElement = processorParameterValue.resolveValue();
                }
                catch (MuleRuntimeException exception) {
                    rootElement = exception;
                }
                orderedPathElements = new ArrayList<FieldNode>(this.fieldPath.getOrderedPathElements());
                orderedPathElements.remove(0);
                charset = debuggingMessage.getCharset();
            } else {
                TypedValue rootElementTyped = debuggingMessage.evaluateExpression(script);
                rootElement = rootElementTyped.getValue();
                orderedPathElements = this.fieldPath.getOrderedPathElements();
                charset = MuleMessageInfoBuilder.calculateCharset(rootElementTyped.getDataType());
            }
            return this.loadInnerFieldsFrom(rootElement, orderedPathElements, charset, script);
        }
        catch (Exception e) {
            logger.warn("Error while evaluating path" + this.fieldPath, (Throwable)e);
            return new ScriptExceptionResponse(new RemoteDebugException(e.getMessage(), e));
        }
    }

    private IDebuggerServerEvent loadInnerFieldsFrom(Object rootElement, List<FieldNode> orderedPathElements, Charset rootElementCharset, String rootElementScript) throws IllegalAccessException {
        Object result = FieldPathAccessor.get(orderedPathElements.iterator(), rootElement);
        String dwAccessor = FieldPathAccessor.getDWAccessor(orderedPathElements.iterator(), rootElement, rootElementScript);
        String rootExpression = this.fieldPath.getRootExpression();
        ObjectFieldDefinition fieldDefinition = ObjectFieldDefinitionFactory.createFromObject(result, rootExpression, this.fieldPath, rootElementCharset, dwAccessor);
        return new LoadInnerFieldsResponse(fieldDefinition);
    }
}

