/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.commands;

import com.mulesoft.mule.debugger.MuleDebuggingContext;
import com.mulesoft.mule.debugger.commands.AbstractCommand;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.response.ExecuteScriptResponse;
import com.mulesoft.mule.debugger.response.IDebuggerServerEvent;
import com.mulesoft.mule.debugger.response.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.response.ObjectFieldDefinitionFactory;
import com.mulesoft.mule.debugger.response.ScriptExceptionResponse;
import com.mulesoft.mule.debugger.response.ScriptResultInfo;
import com.mulesoft.mule.debugger.server.MuleMessageInfoBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public class ExecuteScriptCommand
extends AbstractCommand {
    private final String script;
    private final String message = "TypedValue[value: '%s', dataType: '%s']";

    public ExecuteScriptCommand(String script) {
        this.script = script;
    }

    @Override
    public IDebuggerServerEvent execute() {
        try {
            ScriptResultInfo scriptEvaluationInfo = this.evalScript();
            return new ExecuteScriptResponse(scriptEvaluationInfo);
        }
        catch (Exception e) {
            return new ScriptExceptionResponse(new RemoteDebugException(e.getMessage(), e));
        }
    }

    private ScriptResultInfo evalScript() {
        MuleDebuggingContext debuggingMessage = this.getMuleDebuggingMessage();
        TypedValue result = debuggingMessage.evaluateExpression(this.script);
        Object resultValue = result.getValue();
        Class resultValueClass = resultValue == null ? Object.class : resultValue.getClass();
        ObjectFieldDefinition fromObject = ObjectFieldDefinitionFactory.createFromObject(resultValue, this.script, this.script, debuggingMessage.getCharset(), this.script);
        MuleMessageInfoBuilder.addMimeTypeToDefinition(result, fromObject);
        MediaType resultMediaType = result.getDataType().getMediaType();
        String typedValueString = "";
        typedValueString = resultValue != null ? String.valueOf(result) : String.format("TypedValue[value: '%s', dataType: '%s']", "null", result.getDataType());
        return new ScriptResultInfo(MuleMessageInfoBuilder.create(debuggingMessage), fromObject, String.valueOf(resultValueClass), typedValueString, resultMediaType.getPrimaryType() + "/" + resultMediaType.getSubType());
    }
}

