/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.client;

import com.mulesoft.mule.debugger.client.IDebuggerResponseCallback;
import com.mulesoft.mule.debugger.commons.Breakpoint;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.response.MuleMessageInfo;
import com.mulesoft.mule.debugger.response.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.response.OnExecutionStoppedEvent;
import com.mulesoft.mule.debugger.response.ScriptResultInfo;
import java.util.List;
import java.util.Stack;

public class MessageTrackerDecoratorCallback
implements IDebuggerResponseCallback {
    private final IDebuggerResponseCallback decorated;
    private final Stack<MuleMessageInfo> receivedMessages = new Stack();
    private String lastMessageRootId = null;
    private boolean flowChanged = false;

    public MessageTrackerDecoratorCallback(IDebuggerResponseCallback decorated) {
        this.decorated = decorated;
    }

    @Override
    public void onMuleMessageArrived(MuleMessageInfo muleMessageInfo) {
        this.flowChanged = this.lastMessageRootId != null && !this.lastMessageRootId.equals(muleMessageInfo.getCorrelationId());
        this.lastMessageRootId = muleMessageInfo.getCorrelationId();
        this.receivedMessages.push(muleMessageInfo);
        this.decorated.onMuleMessageArrived(muleMessageInfo);
    }

    @Override
    public void onMuleMessageLeft(MuleMessageInfo muleMessageInfo) {
        this.decorated.onMuleMessageLeft(muleMessageInfo);
    }

    @Override
    public void onExceptionThrown(MuleMessageInfo muleMessageInfo, ObjectFieldDefinition exceptionThrown) {
        this.decorated.onExceptionThrown(muleMessageInfo, exceptionThrown);
    }

    @Override
    public void onScriptEvaluation(ScriptResultInfo info) {
        this.decorated.onScriptEvaluation(info);
    }

    @Override
    public void onConnected() {
        this.decorated.onConnected();
    }

    @Override
    public void onExit() {
        this.decorated.onExit();
    }

    @Override
    public void onError(String error) {
        this.decorated.onError(error);
    }

    @Override
    public void onBreakpointsAdded(List<Breakpoint> breakpoints) {
        this.decorated.onBreakpointsAdded(breakpoints);
    }

    @Override
    public void onBreakpointsRemoved(List<Breakpoint> breakpoints) {
        this.decorated.onBreakpointsRemoved(breakpoints);
    }

    @Override
    public void onFieldUpdated(ObjectFieldDefinition payload) {
        this.decorated.onFieldUpdated(payload);
    }

    @Override
    public void onScriptEvaluationException(RemoteDebugException exception) {
        this.decorated.onScriptEvaluationException(exception);
    }

    @Override
    public void onExceptionBreakpointStatusChange(Boolean status) {
        this.decorated.onExceptionBreakpointStatusChange(status);
    }

    @Override
    public void onResume() {
        if (!this.receivedMessages.isEmpty()) {
            this.receivedMessages.pop();
        }
        if (this.receivedMessages.isEmpty() && !this.flowChanged) {
            this.lastMessageRootId = null;
            this.decorated.onResume();
        }
    }

    @Override
    public void onInnerFieldsLoaded(ObjectFieldDefinition innerFields) {
        this.decorated.onInnerFieldsLoaded(innerFields);
    }

    @Override
    public void onNextStepExecuted() {
        if (!this.receivedMessages.isEmpty()) {
            this.receivedMessages.pop();
            this.decorated.onNextStepExecuted();
        }
    }

    @Override
    public void onRunToProcessorExecuted() {
        this.receivedMessages.pop();
        this.decorated.onRunToProcessorExecuted();
    }

    @Override
    public void onSchedulerStart() {
        this.decorated.onSchedulerStart();
    }

    @Override
    public void onSchedulerStop() {
        this.decorated.onSchedulerStart();
    }

    @Override
    public void onSchedulerActionException(RemoteDebugException exception) {
        this.decorated.onSchedulerActionException(exception);
    }

    @Override
    public void onSchedulerTrigger() {
        this.decorated.onSchedulerTrigger();
    }

    @Override
    public void onExecutionStopped(OnExecutionStoppedEvent onExecutionStoppedEvent) {
        this.decorated.onExecutionStopped(onExecutionStoppedEvent);
    }
}

