/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.client;

import com.mulesoft.mule.debugger.client.DebuggerConnection;
import com.mulesoft.mule.debugger.client.IDebuggerResponseCallback;
import com.mulesoft.mule.debugger.client.MessageTrackerDecoratorCallback;
import com.mulesoft.mule.debugger.commons.Breakpoint;
import com.mulesoft.mule.debugger.commons.SchedulerAction;
import com.mulesoft.mule.debugger.request.AddBreakpointRequest;
import com.mulesoft.mule.debugger.request.EnableExceptionBreakpointRequest;
import com.mulesoft.mule.debugger.request.ExecuteScriptRequest;
import com.mulesoft.mule.debugger.request.ExitDebuggerRequest;
import com.mulesoft.mule.debugger.request.IDebuggerRequest;
import com.mulesoft.mule.debugger.request.LoadInnerFieldsRequest;
import com.mulesoft.mule.debugger.request.NextStepRequest;
import com.mulesoft.mule.debugger.request.RemoveBreakpointRequest;
import com.mulesoft.mule.debugger.request.ResumeDebuggerRequest;
import com.mulesoft.mule.debugger.request.RunToProcessorDebuggerRequest;
import com.mulesoft.mule.debugger.request.SchedulerRequest;
import com.mulesoft.mule.debugger.request.UpdateFieldRequest;
import com.mulesoft.mule.debugger.response.FieldPath;
import com.mulesoft.mule.debugger.response.IDebuggerServerEvent;
import com.mulesoft.mule.debugger.transport.IClientDebuggerProtocol;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DebuggerClient {
    private final DebuggerConnection connection;
    private final Map<IDebuggerRequest, IDebuggerResponseCallback> handler;

    public DebuggerClient(DebuggerConnection connection) {
        this.connection = connection;
        this.handler = new HashMap<IDebuggerRequest, IDebuggerResponseCallback>();
    }

    public void start(IDebuggerResponseCallback defaultHandler) throws IOException {
        this.connection.connect();
        ServerResponseService runnable = new ServerResponseService(new MessageTrackerDecoratorCallback(defaultHandler));
        new Thread((Runnable)runnable, "Debugger Client").start();
    }

    private void unRegisterRequest(IDebuggerRequest request) {
        this.handler.remove(request);
    }

    public void exit() {
        this.sendRequest(new ExitDebuggerRequest());
    }

    public void resume() {
        this.sendRequest(new ResumeDebuggerRequest());
    }

    public void nextStep() {
        this.sendRequest(new NextStepRequest());
    }

    private IClientDebuggerProtocol getProtocol() {
        return this.connection.getProtocol();
    }

    public void runToProcessor(String messagePath) {
        this.sendRequest(new RunToProcessorDebuggerRequest(messagePath));
    }

    public void updateField(FieldPath path, String value) {
        this.sendRequest(new UpdateFieldRequest(path, value));
    }

    public void updateField(FieldPath path, String value, IDebuggerResponseCallback callback) {
        UpdateFieldRequest request = new UpdateFieldRequest(path, value);
        if (callback != null) {
            this.registerCallback(callback, request);
        }
        this.sendRequest(request);
    }

    public void addBreakpoints(Breakpoint ... breakpoints) {
        this.sendRequest(new AddBreakpointRequest(breakpoints));
    }

    public void removeBreakpoints(Breakpoint ... breakpoints) {
        this.sendRequest(new RemoveBreakpointRequest(breakpoints));
    }

    public void enableExceptionBreakpoint(boolean enabled) {
        this.sendRequest(new EnableExceptionBreakpointRequest(enabled));
    }

    public void loadInnerFields(FieldPath parentPath, IDebuggerResponseCallback callback) {
        LoadInnerFieldsRequest request = new LoadInnerFieldsRequest(parentPath);
        if (callback != null) {
            this.registerCallback(callback, request);
        }
        this.sendRequest(request);
    }

    public void executeScript(String script, IDebuggerResponseCallback callback) {
        ExecuteScriptRequest request = new ExecuteScriptRequest(script);
        if (callback != null) {
            this.registerCallback(callback, request);
        }
        this.sendRequest(request);
    }

    public void startScheduler(String appName, String flowName, boolean applyToAll, IDebuggerResponseCallback callback) {
        SchedulerRequest request = new SchedulerRequest(SchedulerAction.START, appName, flowName, applyToAll);
        if (callback != null) {
            this.registerCallback(callback, request);
        }
        this.sendRequest(request);
    }

    public void stopScheduler(String appName, String flowName, boolean applyToAll, IDebuggerResponseCallback callback) {
        SchedulerRequest request = new SchedulerRequest(SchedulerAction.STOP, appName, flowName, applyToAll);
        if (callback != null) {
            this.registerCallback(callback, request);
        }
        this.sendRequest(request);
    }

    public void triggerScheduler(String appName, String flowName, boolean applyToAll) {
        this.sendRequest(new SchedulerRequest(SchedulerAction.TRIGGER, appName, flowName, applyToAll));
    }

    private void sendRequest(IDebuggerRequest request) {
        if (this.getProtocol() != null) {
            this.getProtocol().sendRequest(request);
        }
    }

    protected void registerCallback(IDebuggerResponseCallback callback, IDebuggerRequest request) {
        this.handler.put(request, callback);
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    private class ServerResponseService
    implements Runnable {
        private IClientDebuggerProtocol protocol;
        private final IDebuggerResponseCallback defaultHandler;

        public ServerResponseService(IDebuggerResponseCallback defaultHandler) {
            this.defaultHandler = defaultHandler;
        }

        @Override
        public void run() {
            this.protocol = DebuggerClient.this.getProtocol();
            while (DebuggerClient.this.connection.isConnected()) {
                IDebuggerServerEvent response = this.protocol.getResponse();
                IDebuggerRequest request = response.getRequest();
                if (request != null && DebuggerClient.this.handler.containsKey(request)) {
                    response.callCallback((IDebuggerResponseCallback)DebuggerClient.this.handler.get(request));
                    DebuggerClient.this.unRegisterRequest(request);
                    continue;
                }
                response.callCallback(this.defaultHandler);
            }
        }
    }
}

