/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.rest;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceMethodBlockingFilter
implements Filter {
    private static final Logger LOGGER = LogManager.getLogger(TraceMethodBlockingFilter.class);
    private static final String TRACE_METHOD = "TRACE";

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.info("TraceMethodBlockingFilter initialized - TRACE method will be blocked");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String method = httpRequest.getMethod();
            if (TRACE_METHOD.equalsIgnoreCase(method)) {
                LOGGER.warn("Blocked TRACE request from {} to {}", (Object)httpRequest.getRemoteAddr(), (Object)httpRequest.getRequestURI());
                httpResponse.setStatus(403);
                httpResponse.getWriter().write("TRACE method not allowed");
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        LOGGER.info("TraceMethodBlockingFilter destroyed");
    }
}

