/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.rest;

import com.mulesoft.agent.rest.AgentRequestWrapper;
import com.mulesoft.agent.rest.AgentResponseWrapper;
import com.mulesoft.agent.rest.AgentRestLayer;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RequestLoggingFilter
implements Filter {
    private static final Logger LOGGER = LogManager.getLogger(AgentRestLayer.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest properRequest = (HttpServletRequest)request;
        HttpServletResponse properResponse = (HttpServletResponse)response;
        AgentRequestWrapper wrappedRequest = new AgentRequestWrapper(properRequest);
        AgentResponseWrapper wrappedResponse = new AgentResponseWrapper(properResponse);
        LOGGER.debug("Received request : " + properRequest.getMethod() + " " + properRequest.getRequestURI() + " " + properRequest.getProtocol());
        if (LOGGER.isTraceEnabled()) {
            StringBuilder requestString = new StringBuilder();
            requestString.append("Full Request:\n");
            requestString.append(properRequest.getMethod());
            requestString.append(" ");
            requestString.append(properRequest.getRequestURI());
            requestString.append(" ");
            requestString.append(properRequest.getProtocol());
            requestString.append("\n");
            Enumeration iterator = wrappedRequest.getHeaderNames();
            while (iterator.hasMoreElements()) {
                String header = (String)iterator.nextElement();
                requestString.append(header);
                requestString.append(": ");
                requestString.append(properRequest.getHeader(header));
                requestString.append("\n");
            }
            requestString.append("\n");
            LOGGER.trace(requestString.toString());
            if (properRequest.getContentType() != null && properRequest.getContentType().equals("application/octet-stream")) {
                requestString.append("Request body is a binary string");
            } else {
                requestString.append(wrappedResponse.getWriter().getCopy());
            }
            LOGGER.trace(requestString.toString());
        }
        filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        LOGGER.debug("Responding to request: " + properRequest.getProtocol() + " " + properResponse.getStatus());
        if (LOGGER.isTraceEnabled()) {
            StringBuilder responseString = new StringBuilder();
            responseString.append("Full Response:\n");
            responseString.append(properRequest.getProtocol());
            responseString.append(" ");
            responseString.append(properResponse.getStatus());
            responseString.append("\n");
            for (String header : properResponse.getHeaderNames()) {
                responseString.append(header);
                responseString.append(": ");
                responseString.append(properResponse.getHeader(header));
                responseString.append("\n");
            }
            responseString.append("\n");
            responseString.append(wrappedResponse.getWriter().getCopy());
            LOGGER.trace(responseString.toString());
        }
    }
}

