/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.rest;

import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.http.HttpHeader;

public class AuthorizationFilter
implements Filter {
    private static final Logger LOGGER = LogManager.getLogger(AuthorizationFilter.class);
    private static final String HEADER_AUTHORIZATION_KEY = HttpHeader.AUTHORIZATION.name();
    private static final String PROPERTY_AUTHORIZATION_TOKEN = "agent-token-authorization";

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest properRequest = (HttpServletRequest)request;
        HttpServletResponse properResponse = (HttpServletResponse)response;
        LOGGER.debug("Received request : " + properRequest.getMethod() + " " + properRequest.getRequestURI() + " " + properRequest.getProtocol());
        try {
            this.authenticateIfNeeded(properRequest);
            filterChain.doFilter(request, response);
        }
        catch (MissingAuthorizationException e) {
            properResponse.sendError(400);
        }
        catch (AuthorizationFailedException e) {
            properResponse.sendError(401);
        }
        catch (TokenInvalidFormatException e) {
            LOGGER.error("Authotization token has an invalid format: must be an UUID string.");
            properResponse.sendError(401);
        }
    }

    private Optional<String> getAuthorizationToken() {
        return Optional.ofNullable(System.getProperty(PROPERTY_AUTHORIZATION_TOKEN));
    }

    private boolean doesRequestMustBeAuthorized() {
        return this.getAuthorizationToken().isPresent();
    }

    private Optional<String> getAuthenticationValue(HttpServletRequest properRequest) {
        return Optional.ofNullable(properRequest.getHeader(HEADER_AUTHORIZATION_KEY));
    }

    private void authenticateIfNeeded(HttpServletRequest request) throws MissingAuthorizationException, AuthorizationFailedException, TokenInvalidFormatException {
        if (this.doesRequestMustBeAuthorized()) {
            this.authenticate(request);
        }
    }

    private void validateAuthorizationToken(String token) throws TokenInvalidFormatException {
        try {
            UUID.fromString(token);
        }
        catch (Exception e) {
            throw new TokenInvalidFormatException();
        }
    }

    private void authenticate(HttpServletRequest request) throws MissingAuthorizationException, AuthorizationFailedException, TokenInvalidFormatException {
        String token = this.getAuthenticationValue(request).orElseThrow(() -> new MissingAuthorizationException());
        this.validateAuthorizationToken(token);
        if (!this.getAuthorizationToken().get().equals(token)) {
            throw new AuthorizationFailedException();
        }
    }

    private static class TokenInvalidFormatException
    extends Exception {
        private TokenInvalidFormatException() {
        }
    }

    private static class MissingAuthorizationException
    extends Exception {
        private MissingAuthorizationException() {
        }
    }

    private static class AuthorizationFailedException
    extends Exception {
        private AuthorizationFailedException() {
        }
    }
}

