/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.rest;

import com.mulesoft.agent.jackson.AllowUnknownPropertiesContextResolver;
import com.mulesoft.agent.rest.AuthorizationFilter;
import com.mulesoft.agent.rest.RequestLoggingFilter;
import com.mulesoft.agent.rest.RestCertificate;
import com.mulesoft.agent.rest.RestRequester;
import com.mulesoft.agent.rest.TraceMethodBlockingFilter;
import com.mulesoft.agent.transport.Request;
import com.mulesoft.agent.transport.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Application;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class AgentRestLayer {
    private static final String MULE_ROOT = "/mule/*";
    private static final Logger LOGGER = LogManager.getLogger(AgentRestLayer.class);
    private Connector connector;
    private Server server;
    private Client client;
    private String rootPath;
    private String host;
    private int port;
    private RestCertificate security;
    private RestRequester restRequester = new RestRequester();
    private ServletContainer servletContainer;

    public AgentRestLayer(String host, int port, RestCertificate security) {
        this.host = host;
        this.port = port;
        this.security = security;
    }

    public void initialise(final List<Object> restListeners, boolean loggingEnabled) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException, KeyManagementException {
        System.setProperty("org.eclipse.jetty.LEVEL", "WARN");
        this.server = new Server();
        this.connector = this.createConnector();
        ResourceConfig resourceConfig = ResourceConfig.forApplication((Application)new Application(){

            public Set<Object> getSingletons() {
                return new HashSet<Object>(restListeners);
            }
        });
        resourceConfig.packages(new String[]{"org.glassfish.jersey.examples.multipart"});
        resourceConfig.register(AllowUnknownPropertiesContextResolver.class);
        resourceConfig.register(MultiPartFeature.class);
        this.servletContainer = new ServletContainer(resourceConfig);
        ServletHolder servletHolder = new ServletHolder((Servlet)this.servletContainer);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)this.server, "/");
        context.addServlet(servletHolder, this.rootPath == null ? MULE_ROOT : this.rootPath);
        context.setInitParameter("jersey.config.server.provider.classnames", "org.glassfish.jersey.filter.LoggingFilter;org.glassfish.jersey.media.multipart.MultiPartFeature");
        context.addFilter(TraceMethodBlockingFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        context.addFilter(AuthorizationFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        if (loggingEnabled) {
            context.addFilter(RequestLoggingFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        }
        this.server.setHandler((Handler)context);
    }

    public Response send(Request message) {
        return this.restRequester.request(message, this.client, this.getMessageBodyFactory());
    }

    public void enable() throws Exception {
        this.server.addConnector(this.connector);
        for (Connector c : this.server.getConnectors()) {
            c.start();
        }
        this.connector.start();
    }

    public void start() throws Exception {
        this.server.start();
        this.startClient();
    }

    public void stop() throws Exception {
        if (this.client != null) {
            this.doSilently(() -> this.client.close());
        }
        if (this.server != null) {
            this.doSilently(() -> this.server.stop());
        }
        if (this.servletContainer != null) {
            this.doSilently(() -> this.servletContainer.destroy());
        }
        if (this.connector != null) {
            this.doSilently(() -> this.connector.stop());
            this.doSilently(() -> this.connector.shutdown());
        }
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public MessageBodyFactory getMessageBodyFactory() {
        InjectionManager im = this.servletContainer.getApplicationHandler().getInjectionManager();
        MessageBodyFactory messageBodyFactory = new MessageBodyFactory(null);
        messageBodyFactory.initialize(im);
        return messageBodyFactory;
    }

    private void startClient() {
        if (this.security != null) {
            try {
                SSLContext ctx = this.buildClientSSLContext();
                this.client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).sslContext(ctx).hostnameVerifier((HostnameVerifier)new AllowAllHostnameVerifier()).property("jersey.config.client.suppressHttpComplianceValidation", (Object)"true")).property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)"true")).build();
            }
            catch (Exception e) {
                LOGGER.error("Could not start the REST client to connect to callback");
            }
        } else {
            try {
                this.client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).hostnameVerifier((HostnameVerifier)new AllowAllHostnameVerifier()).property("jersey.config.client.suppressHttpComplianceValidation", (Object)"true")).property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)"true")).build();
            }
            catch (Exception e) {
                LOGGER.error("Could not start the REST client to connect to callback");
            }
        }
    }

    private Connector createConnector() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException, KeyManagementException {
        if (this.security == null) {
            LOGGER.warn("REST Agent transport is starting with no security");
            ServerConnector serverConnector = new ServerConnector(this.server);
            serverConnector.setPort(this.port);
            serverConnector.setHost(this.host);
            return serverConnector;
        }
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setSslContext(this.buildClientSSLContext());
        sslContextFactory.setNeedClientAuth(true);
        ServerConnector serverConnector = new ServerConnector(this.server, (SslContextFactory)sslContextFactory);
        serverConnector.setPort(this.port);
        serverConnector.setHost(this.host);
        return serverConnector;
    }

    private void doSilently(CheckedTask task) {
        block2: {
            try {
                task.run();
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug((Object)e);
            }
        }
    }

    private KeyStore buildTruststore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore truststore = null;
        if (this.security.getTrustStore().isPresent()) {
            File truststoreFile = (File)this.security.getTrustStore().get();
            truststore = KeyStore.getInstance(this.security.getTrustStoreType());
            try (FileInputStream trustStoreStream = new FileInputStream(truststoreFile);){
                truststore.load(trustStoreStream, this.security.getTrustStorePassword());
            }
            catch (FileNotFoundException | NullPointerException e) {
                LOGGER.error("Error building the trust store: {}", (Object)e.getMessage());
                throw new CertificateException(e);
            }
            LOGGER.info("Truststore for Agent API REST is {}", (Object)truststoreFile.toPath().toAbsolutePath());
        } else {
            LOGGER.info("Truststore for Agent API REST is JVM");
        }
        return truststore;
    }

    private TrustManager[] buildTrustManagers() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore truststore = this.buildTruststore();
        if (truststore == null) {
            return null;
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(truststore);
        return trustManagerFactory.getTrustManagers();
    }

    private KeyStore buildKeystore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (this.security == null) {
            return null;
        }
        KeyStore keystore = KeyStore.getInstance(this.security.getKeyStoreType());
        File keyStoreFile = new File(this.security.getKeyStorePath());
        keystore.load(new FileInputStream(keyStoreFile), this.security.getKeyStorePassword());
        return keystore;
    }

    private SSLContext buildClientSSLContext() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keystore = this.buildKeystore();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        String keyPassword = this.security.getKeyPassword();
        KeyManagerFactory sunX509 = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        sunX509.init(keystore, keyPassword == null ? null : keyPassword.toCharArray());
        sslContext.init(sunX509.getKeyManagers(), this.buildTrustManagers(), new SecureRandom());
        return sslContext;
    }

    @FunctionalInterface
    static interface CheckedTask {
        public void run() throws Exception;
    }
}

