/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class AgentResponseWrapper
extends HttpServletResponseWrapper {
    private LoggingWriter writer;
    private ServletOutputStream outputStream;
    private HttpServletResponse originalResponse;

    public AgentResponseWrapper(HttpServletResponse response) throws IOException {
        super(response);
        this.originalResponse = response;
        this.outputStream = this.originalResponse.getOutputStream();
        this.writer = new LoggingWriter(new OutputStreamWriter((OutputStream)this.outputStream));
    }

    public LoggingWriter getWriter() throws IOException {
        return this.writer;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public class LoggingWriter
    extends PrintWriter {
        private StringBuilder copy;

        public LoggingWriter(Writer writer) {
            super(writer);
            this.copy = new StringBuilder();
        }

        @Override
        public void write(int c) {
            this.copy.append((char)c);
            super.write(c);
        }

        @Override
        public void write(char[] chars, int offset, int length) {
            this.copy.append(chars, offset, length);
            super.write(chars, offset, length);
        }

        @Override
        public void write(String string, int offset, int length) {
            this.copy.append(string, offset, length);
            super.write(string, offset, length);
        }

        public String getCopy() {
            return this.copy.toString();
        }
    }
}

