/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.rest;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class AgentRequestWrapper
extends HttpServletRequestWrapper {
    private String body;
    private HttpServletRequest originalRequest;

    public AgentRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.originalRequest = request;
        if ("application/json".equals(this.originalRequest.getContentType())) {
            this.body = "";
            try (BufferedReader bufferedReader = request.getReader();){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    this.body = this.body + line;
                }
            }
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if ("application/json".equals(this.originalRequest.getContentType())) {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body.getBytes());
            return new ServletInputStream(){

                public int read() throws IOException {
                    return byteArrayInputStream.read();
                }

                public boolean isReady() {
                    return false;
                }

                public void setReadListener(ReadListener readListener) {
                }

                public boolean isFinished() {
                    return true;
                }
            };
        }
        return this.originalRequest.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        if ("application/json".equals(this.originalRequest.getContentType())) {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }
        return this.originalRequest.getReader();
    }
}

