/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.scheduling;

import com.mulesoft.agent.configuration.ApplicationConfiguration;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.ConfigurationLevel;
import com.mulesoft.agent.configuration.NotRestartable;
import com.mulesoft.agent.configuration.RequiresRestart;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.domain.scheduler.CronScheduler;
import com.mulesoft.agent.domain.scheduler.FixedFrequencyScheduler;
import com.mulesoft.agent.domain.scheduler.Scheduler;
import com.mulesoft.agent.domain.scheduler.SchedulerNotification;
import com.mulesoft.agent.domain.scheduler.SchedulerType;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.SchedulingService;
import com.mulesoft.agent.services.scheduling.AgentSchedulerConfigurationFactory;
import com.mulesoft.agent.services.scheduling.SchedulerConfiguration;
import com.mulesoft.agent.services.scheduling.exception.UnsupportedSchedulerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.source.SchedulerMessageSource;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;

@Named(value="mule.agent.scheduling.service")
@Singleton
@NotRestartable
public class AgentSchedulingService
extends ConfigurableAgentService
implements SchedulingService,
DeploymentServiceAware {
    private static final Logger LOGGER = LogManager.getLogger(AgentSchedulingService.class);
    private static final String ERROR_APPLICATION_NOT_FOUND_TEMPLATE = "Application %s does not exists, could not get schedulers.";
    private static final String SKIPPING_SCHEDULER_CONFIG_APP_NOT_FOUND = "Skipping scheduler configuration of application {} as it does not exist.";
    private static final String SCHEDULER_CONFIGURATION_BEFORE_UPDATE_TEMPLATE = "%s configuration before update";
    private static final String SCHEDULER_CONFIGURATION_AFTER_UPDATE_TEMPLATE = "%s configuration after update";
    @Configurable(type=Type.DYNAMIC, value="[]", level=ConfigurationLevel.APPLICATION, update="updateConfiguration", delete="deleteConfiguration")
    @RequiresRestart(stop="doStop", start="startConfiguration")
    private SchedulerConfiguration[] schedulerConfigurations;
    private DeploymentService deploymentService;
    private AgentApplicationDeploymentListener deploymentApplicationListener = new AgentApplicationDeploymentListener();
    @Inject
    private List<InternalMessageHandler<SchedulerNotification>> schedulingNotificationHandlers;
    @Inject
    private AgentSchedulerConfigurationFactory agentSchedulerConfigurationFactory;

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setAgentSchedulerConfigurationFactory(AgentSchedulerConfigurationFactory agentSchedulerConfigurationFactory) {
        this.agentSchedulerConfigurationFactory = agentSchedulerConfigurationFactory;
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>(this.schedulingNotificationHandlers);
    }

    public void doStart() throws MuleException {
        this.deploymentService.addDeploymentListener((DeploymentListener)this.deploymentApplicationListener);
        for (SchedulerConfiguration schedulerConfiguration : this.schedulerConfigurations) {
            Application application = this.deploymentService.findApplication(schedulerConfiguration.getApplicationName());
            if (application != null) {
                this.applySchedulerConfigurations(schedulerConfiguration.getApplicationName(), schedulerConfiguration.getSchedulers());
                continue;
            }
            LOGGER.debug(SKIPPING_SCHEDULER_CONFIG_APP_NOT_FOUND, (Object)schedulerConfiguration.getApplicationName());
        }
    }

    public void doStop() throws MuleException {
        this.deploymentService.removeDeploymentListener((DeploymentListener)this.deploymentApplicationListener);
    }

    public List<Scheduler> getSchedulers(String applicationName) throws IllegalArgumentException {
        Application application = this.deploymentService.findApplication(applicationName);
        if (application == null) {
            throw new IllegalArgumentException(String.format(ERROR_APPLICATION_NOT_FOUND_TEMPLATE, applicationName));
        }
        ConfigurationComponentLocator componentLocator = this.getConfigurationComponentLocator(application);
        List components = componentLocator.find(SchedulerMessageSource.SCHEDULER_MESSAGE_SOURCE_IDENTIFIER);
        return components.stream().map(component -> this.agentSchedulerConfigurationFactory.create((Component)component, componentLocator)).collect(Collectors.toList());
    }

    public void applySchedulerConfigurations(String applicationName, List<Scheduler> schedulers) {
        Application application = this.deploymentService.findApplication(applicationName);
        if (application == null) {
            LOGGER.debug(SKIPPING_SCHEDULER_CONFIG_APP_NOT_FOUND);
            return;
        }
        ConfigurationComponentLocator componentLocator = this.getConfigurationComponentLocator(application);
        schedulers.forEach(scheduler -> this.configureScheduler((Scheduler)scheduler, componentLocator));
    }

    public List<Scheduler> mergeSchedulers(List<Scheduler> applicationSchedulers, List<Scheduler> configuredSchedulers) {
        HashSet<Scheduler> schedulers = new HashSet<Scheduler>();
        configuredSchedulers.forEach(configuredScheduler -> {
            boolean shouldMerge = applicationSchedulers.stream().anyMatch(applicationScheduler -> configuredScheduler.equals(applicationScheduler));
            if (shouldMerge) {
                schedulers.add((Scheduler)configuredScheduler);
            }
        });
        schedulers.addAll(applicationSchedulers);
        return new LinkedList<Scheduler>(schedulers);
    }

    private Optional<SchedulerConfiguration> findSchedulerConfigurations(String applicationName) {
        return Arrays.stream(this.schedulerConfigurations).filter(configuration -> configuration.getApplicationName().equals(applicationName)).findAny();
    }

    private ConfigurationComponentLocator getConfigurationComponentLocator(Application application) {
        return (ConfigurationComponentLocator)application.getRegistry().lookupByName("_muleConfigurationComponentLocator").orElseThrow(() -> new IllegalArgumentException(String.format("Could not retrieve configuration component locator for application %s.", application.getArtifactName())));
    }

    private void configureScheduler(Scheduler scheduler, ConfigurationComponentLocator componentLocator) {
        try {
            String flowName = scheduler.getFlowName();
            Location location = Location.builderFromStringRepresentation((String)flowName).addSourcePart().build();
            Optional schedulerComponent = componentLocator.find(location);
            if (!schedulerComponent.isPresent()) {
                LOGGER.info("Unable to configure scheduler as it does not exists for flow {}.", (Object)flowName);
                return;
            }
            Scheduler currentConfiguration = this.agentSchedulerConfigurationFactory.create((Component)schedulerComponent.get(), componentLocator);
            if (!currentConfiguration.equals((Object)scheduler)) {
                String message = "Unable to apply the scheduler configuration for flow {} scheduler {}: Scheduler type in the application {} is not {}";
                LOGGER.info(message, (Object)flowName, (Object)currentConfiguration.getName(), (Object)currentConfiguration.getType(), (Object)scheduler.getType());
                return;
            }
            if (currentConfiguration.equals((Object)scheduler) && currentConfiguration.hasSameConfiguration(scheduler)) {
                LOGGER.info("Skipping configuration of scheduler from flow {} as it is already configured.", (Object)flowName);
                return;
            }
            org.mule.runtime.api.source.SchedulerConfiguration schedulerConfiguration = ((SchedulerMessageSource)schedulerComponent.get()).getConfiguration();
            this.updateSchedulerConfigurationInMuleRuntime(scheduler, schedulerConfiguration);
            SchedulerMessageSource schedulerMessageSource = (SchedulerMessageSource)schedulerComponent.get();
            if (this.shouldRestartScheduler(scheduler, schedulerMessageSource)) {
                LOGGER.info("Restarting scheduler of flow {} to apply new configuration.", (Object)scheduler.getFlowName());
                schedulerMessageSource.stop();
                schedulerMessageSource.start();
            } else {
                LOGGER.info("Stopping scheduler of flow {}.", (Object)scheduler.getFlowName());
                schedulerMessageSource.stop();
            }
        }
        catch (UnsupportedSchedulerException e) {
            LOGGER.error("Scheduler not supported in flow '{}'. Reason: {}", (Object)scheduler.getFlowName(), (Object)e.getMessage());
            LOGGER.debug((Object)e);
        }
        catch (MuleException e) {
            LOGGER.error("There was an error configuring the Schedulers. Exception was: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
        }
    }

    private boolean shouldRestartScheduler(Scheduler scheduler, SchedulerMessageSource schedulerMessageSource) {
        if (scheduler.getEnabled() == null) {
            return schedulerMessageSource.isStarted();
        }
        return scheduler.getEnabled();
    }

    private void updateSchedulerConfigurationInMuleRuntime(Scheduler newSchedulerConfiguration, org.mule.runtime.api.source.SchedulerConfiguration muleSchedulerConfiguration) {
        if (SchedulerType.FixedFrequencyScheduler.equals((Object)newSchedulerConfiguration.getType())) {
            FixedFrequencyScheduler fixedFrequencyScheduler = (FixedFrequencyScheduler)newSchedulerConfiguration;
            org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler muleFixedFrequencyScheduler = (org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler)muleSchedulerConfiguration;
            this.updateSchedulerConfigurationInMuleRuntime(fixedFrequencyScheduler, muleFixedFrequencyScheduler);
        } else if (SchedulerType.CronScheduler.equals((Object)newSchedulerConfiguration.getType())) {
            CronScheduler cronScheduler = (CronScheduler)newSchedulerConfiguration;
            org.mule.runtime.core.api.source.scheduler.CronScheduler muleCronScheduler = (org.mule.runtime.core.api.source.scheduler.CronScheduler)muleSchedulerConfiguration;
            this.updateSchedulerConfigurationInMuleRuntime(cronScheduler, muleCronScheduler);
        } else {
            throw new IllegalArgumentException(String.format("Could not configure scheduler. Scheduler type %s unknown for flow %s.", newSchedulerConfiguration.getType(), newSchedulerConfiguration.getFlowName()));
        }
    }

    private void updateSchedulerConfigurationInMuleRuntime(FixedFrequencyScheduler newSchedulerConfiguration, org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler muleSchedulerConfiguration) {
        if (this.requiresUpdate(newSchedulerConfiguration)) {
            String message = String.format(SCHEDULER_CONFIGURATION_BEFORE_UPDATE_TEMPLATE, newSchedulerConfiguration.getFlowName());
            this.logSchedulerConfigurations(message, muleSchedulerConfiguration);
            Optional.ofNullable(newSchedulerConfiguration.getStartDelay()).ifPresent(arg_0 -> ((org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler)muleSchedulerConfiguration).setStartDelay(arg_0));
            Optional.ofNullable(newSchedulerConfiguration.getTimeUnit()).ifPresent(arg_0 -> ((org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler)muleSchedulerConfiguration).setTimeUnit(arg_0));
            Optional.ofNullable(newSchedulerConfiguration.getFrequency()).ifPresent(arg_0 -> ((org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler)muleSchedulerConfiguration).setFrequency(arg_0));
            message = String.format(SCHEDULER_CONFIGURATION_AFTER_UPDATE_TEMPLATE, newSchedulerConfiguration.getFlowName());
            this.logSchedulerConfigurations(message, muleSchedulerConfiguration);
        }
    }

    private void updateSchedulerConfigurationInMuleRuntime(CronScheduler newSchedulerConfiguration, org.mule.runtime.core.api.source.scheduler.CronScheduler muleSchedulerConfiguration) {
        if (this.requiresUpdate(newSchedulerConfiguration)) {
            String message = String.format(SCHEDULER_CONFIGURATION_BEFORE_UPDATE_TEMPLATE, newSchedulerConfiguration.getFlowName());
            this.logSchedulerConfigurations(message, muleSchedulerConfiguration);
            Optional.ofNullable(newSchedulerConfiguration.getExpression()).ifPresent(arg_0 -> ((org.mule.runtime.core.api.source.scheduler.CronScheduler)muleSchedulerConfiguration).setExpression(arg_0));
            Optional.ofNullable(newSchedulerConfiguration.getTimeZone()).ifPresent(arg_0 -> ((org.mule.runtime.core.api.source.scheduler.CronScheduler)muleSchedulerConfiguration).setTimeZone(arg_0));
            message = String.format(SCHEDULER_CONFIGURATION_AFTER_UPDATE_TEMPLATE, newSchedulerConfiguration.getFlowName());
            this.logSchedulerConfigurations(message, muleSchedulerConfiguration);
        }
    }

    private boolean requiresUpdate(FixedFrequencyScheduler scheduler) {
        return scheduler.getStartDelay() != null || scheduler.getTimeUnit() != null || scheduler.getFrequency() != null;
    }

    private boolean requiresUpdate(CronScheduler scheduler) {
        return scheduler.getExpression() != null || scheduler.getTimeZone() != null;
    }

    private void logSchedulerConfigurations(String message, org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler scheduler) {
        LOGGER.info("{} [startDelay: '{}' frequency: '{}' timeUnit:'{}']", (Object)message, (Object)scheduler.getStartDelay(), (Object)scheduler.getFrequency(), (Object)scheduler.getTimeUnit());
    }

    private void logSchedulerConfigurations(String message, org.mule.runtime.core.api.source.scheduler.CronScheduler scheduler) {
        LOGGER.info("{} [expression: '{}' timezone: '{}']", (Object)message, (Object)scheduler.getExpression(), (Object)scheduler.getTimeZone());
    }

    public void updateConfiguration(Object configurations) {
        ApplicationConfiguration[] configurationsAsArray = (ApplicationConfiguration[])configurations;
        if (configurationsAsArray == null || configurationsAsArray.length == 0) {
            return;
        }
        for (ApplicationConfiguration configuration : configurationsAsArray) {
            SchedulerConfiguration configurationAsScheduler = (SchedulerConfiguration)configuration;
            for (Scheduler newScheduler : configurationAsScheduler.getSchedulers()) {
                String applicationName = configurationAsScheduler.getApplicationName();
                String schedulerName = newScheduler.getName();
                boolean isApplicationExists = this.isSchedulerConfigurationHasApplication(applicationName);
                boolean isApplicationAndSchedulerExists = this.isSchedulerConfigurationHasApplicationAndScheduler(applicationName, schedulerName);
                if (isApplicationAndSchedulerExists) {
                    this.updateScheduler(applicationName, newScheduler);
                    continue;
                }
                if (isApplicationExists) {
                    this.addScheduler(applicationName, newScheduler);
                    continue;
                }
                this.addSchedulerConfiguration(configurationAsScheduler);
            }
        }
    }

    public void deleteConfiguration(Object configurations) {
        ApplicationConfiguration[] configurationsAsArray;
        for (ApplicationConfiguration configuration : configurationsAsArray = (ApplicationConfiguration[])configurations) {
            SchedulerConfiguration configurationAsScheduler = (SchedulerConfiguration)configuration;
            for (Scheduler newScheduler : configurationAsScheduler.getSchedulers()) {
                String schedulerName;
                String applicationName = configurationAsScheduler.getApplicationName();
                boolean isApplicationAndSchedulerExists = this.isSchedulerConfigurationHasApplicationAndScheduler(applicationName, schedulerName = newScheduler.getName());
                if (!isApplicationAndSchedulerExists) continue;
                this.deleteScheduler(applicationName, newScheduler);
            }
        }
    }

    private boolean isSchedulerConfigurationHasApplication(String applicationName) {
        for (SchedulerConfiguration configuration : this.schedulerConfigurations) {
            if (!configuration.getApplicationName().equals(applicationName)) continue;
            return true;
        }
        return false;
    }

    private boolean isSchedulerConfigurationHasApplicationAndScheduler(String applicationName, String schedulerName) {
        for (SchedulerConfiguration configuration : this.schedulerConfigurations) {
            if (!configuration.getApplicationName().equals(applicationName)) continue;
            for (Scheduler scheduler : configuration.getSchedulers()) {
                if (!scheduler.getName().equals(schedulerName)) continue;
                return true;
            }
        }
        return false;
    }

    private void updateScheduler(String applicationName, Scheduler scheduler) {
        for (SchedulerConfiguration configuration : this.schedulerConfigurations) {
            if (!configuration.getApplicationName().equals(applicationName)) continue;
            for (Scheduler actual : configuration.getSchedulers()) {
                if (!scheduler.equals((Object)actual)) continue;
                this.copyProperties(actual, scheduler);
            }
        }
    }

    private void addScheduler(String applicationName, Scheduler scheduler) {
        for (SchedulerConfiguration configuration : this.schedulerConfigurations) {
            if (!configuration.getApplicationName().equals(applicationName)) continue;
            configuration.getSchedulers().add(scheduler);
        }
    }

    private void deleteScheduler(String applicationName, Scheduler scheduler) {
        for (SchedulerConfiguration configuration : this.schedulerConfigurations) {
            if (!configuration.getApplicationName().equals(applicationName)) continue;
            for (Scheduler actual : configuration.getSchedulers()) {
                if (!actual.getName().equals(scheduler.getName())) continue;
                try {
                    configuration.getSchedulers().remove(actual);
                    scheduler.setEnabled(Boolean.valueOf(false));
                    this.applySchedulerConfigurations(applicationName, Arrays.asList(scheduler));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.debug("There was an error deleting the schedulers {} from the application {}. Exception was: {}", (Object)scheduler.getName(), (Object)applicationName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
                return;
            }
        }
    }

    private void addSchedulerConfiguration(SchedulerConfiguration schedulerConfiguration) {
        ArrayList<SchedulerConfiguration> list = new ArrayList<SchedulerConfiguration>(Arrays.asList(this.schedulerConfigurations));
        list.add(schedulerConfiguration);
        this.schedulerConfigurations = list.toArray(new SchedulerConfiguration[list.size()]);
    }

    private void copyProperties(Scheduler destination, Scheduler origin) {
        if (origin.getType().equals((Object)SchedulerType.CronScheduler)) {
            this.copyProperties((CronScheduler)destination, (CronScheduler)origin);
        } else {
            this.copyProperties((FixedFrequencyScheduler)destination, (FixedFrequencyScheduler)origin);
        }
    }

    private void copyProperties(CronScheduler destination, CronScheduler origin) {
        destination.setExpression(origin.getExpression());
        destination.setTimeZone(origin.getTimeZone());
        destination.setEnabled(origin.getEnabled());
        destination.setFlowName(origin.getFlowName());
    }

    private void copyProperties(FixedFrequencyScheduler destination, FixedFrequencyScheduler origin) {
        destination.setFrequency(origin.getFrequency());
        destination.setStartDelay(origin.getStartDelay());
        destination.setTimeUnit(origin.getTimeUnit());
        destination.setEnabled(origin.getEnabled());
        destination.setFlowName(origin.getFlowName());
    }

    public void startConfiguration(Object configuration) {
        SchedulerConfiguration[] configurationsToRestart;
        this.deploymentService.addDeploymentListener((DeploymentListener)this.deploymentApplicationListener);
        for (SchedulerConfiguration configurationToRestart : configurationsToRestart = (SchedulerConfiguration[])configuration) {
            for (Scheduler schedulerToRestart : configurationToRestart.getSchedulers()) {
                String applicationName = configurationToRestart.getApplicationName();
                String schedulerName = schedulerToRestart.getName();
                boolean isApplicationExists = this.isSchedulerConfigurationHasApplication(applicationName);
                boolean isApplicationAndSchedulerExists = this.isSchedulerConfigurationHasApplicationAndScheduler(applicationName, schedulerName);
                if (isApplicationAndSchedulerExists) {
                    this.applySchedulerConfigurations(applicationName, schedulerName);
                    continue;
                }
                if (!isApplicationExists) {
                    LOGGER.debug(SKIPPING_SCHEDULER_CONFIG_APP_NOT_FOUND, (Object)applicationName);
                    continue;
                }
                LOGGER.debug("Scheduler {} does not exist in Application {}. Skipping scheduler configuration.", (Object)schedulerName, (Object)applicationName);
            }
        }
    }

    private void applySchedulerConfigurations(String applicationName, String schedulerName) {
        for (SchedulerConfiguration configuration : this.schedulerConfigurations) {
            if (!configuration.getApplicationName().equals(applicationName)) continue;
            for (Scheduler scheduler : configuration.getSchedulers()) {
                if (!scheduler.getName().equals(schedulerName)) continue;
                this.applySchedulerConfigurations(applicationName, Arrays.asList(scheduler));
            }
        }
    }

    public void applySchedulerConfigurationsManagedInApplicationDescriptor(String applicationName, String flowName) {
        List<Scheduler> configuredSchedulers = this.findSchedulersInSchedulerConfigurations(applicationName, flowName);
        this.applySchedulerConfigurations(applicationName, configuredSchedulers);
        SchedulerNotification schedulerNotification = new SchedulerNotification(applicationName, this.mergeSchedulers(this.getSchedulers(applicationName), configuredSchedulers));
        this.schedulingNotificationHandlers.forEach(handler -> handler.handle((Object)schedulerNotification));
    }

    private List<Scheduler> findSchedulersInSchedulerConfigurations(String applicationName, String flowName) {
        Optional<SchedulerConfiguration> schedulerConfiguration = this.findSchedulerConfigurations(applicationName);
        List<Object> applicationSchedulers = new LinkedList<Scheduler>();
        if (schedulerConfiguration.isPresent()) {
            applicationSchedulers = schedulerConfiguration.get().getSchedulers().stream().filter(s -> s.getFlowName().equals(flowName)).collect(Collectors.toList());
        }
        return applicationSchedulers;
    }

    public void triggerScheduler(String applicationName, String flowName) {
        Application application = this.findApplication(applicationName);
        Scheduler scheduler = this.getSchedulerByFlowName(applicationName, flowName);
        ConfigurationComponentLocator componentLocator = this.getConfigurationComponentLocator(application);
        this.trigger(scheduler, componentLocator);
    }

    private void trigger(Scheduler scheduler, ConfigurationComponentLocator componentLocator) {
        String flowName = scheduler.getFlowName();
        Location location = Location.builderFromStringRepresentation((String)flowName).addSourcePart().build();
        Optional schedulerComponent = componentLocator.find(location);
        if (!schedulerComponent.isPresent()) {
            LOGGER.info("Unable to trigger the scheduler for flow {}. Reason: Scheduler not found", (Object)flowName);
            return;
        }
        LOGGER.info("Manually triggering the scheduler in the flow name: {}", (Object)flowName);
        ((SchedulerMessageSource)schedulerComponent.get()).trigger();
    }

    private Application findApplication(String applicationName) {
        return Optional.ofNullable(this.deploymentService.findApplication(applicationName)).orElseThrow(() -> new IllegalArgumentException(String.format(ERROR_APPLICATION_NOT_FOUND_TEMPLATE, applicationName)));
    }

    private Scheduler getSchedulerByFlowName(String applicationName, String flowName) {
        return this.getSchedulers(applicationName).stream().filter(s -> s.getFlowName().equals(flowName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Flow %s not found in the application %s.", flowName, applicationName)));
    }

    private class AgentApplicationDeploymentListener
    implements DeploymentListener {
        private AgentApplicationDeploymentListener() {
        }

        public void onDeploymentSuccess(String applicationName) {
            Optional schedulerConfiguration = AgentSchedulingService.this.findSchedulerConfigurations(applicationName);
            LinkedList<Scheduler> configuredSchedulers = new LinkedList();
            if (schedulerConfiguration.isPresent()) {
                String schedulerAppName = ((SchedulerConfiguration)schedulerConfiguration.get()).getApplicationName();
                configuredSchedulers = ((SchedulerConfiguration)schedulerConfiguration.get()).getSchedulers();
                AgentSchedulingService.this.applySchedulerConfigurations(schedulerAppName, configuredSchedulers);
            }
            SchedulerNotification schedulerNotification = new SchedulerNotification(applicationName, AgentSchedulingService.this.mergeSchedulers(AgentSchedulingService.this.getSchedulers(applicationName), configuredSchedulers));
            AgentSchedulingService.this.schedulingNotificationHandlers.forEach(handler -> handler.handle((Object)schedulerNotification));
        }
    }
}

