/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.scheduling;

import com.mulesoft.agent.domain.scheduler.CronScheduler;
import com.mulesoft.agent.domain.scheduler.FixedFrequencyScheduler;
import com.mulesoft.agent.domain.scheduler.Scheduler;
import com.mulesoft.agent.domain.scheduler.SchedulerType;
import com.mulesoft.agent.services.scheduling.exception.UnsupportedSchedulerException;
import java.util.Optional;
import javax.inject.Singleton;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.source.CronSchedulerConfiguration;
import org.mule.runtime.api.source.FixedFrequencySchedulerConfiguration;
import org.mule.runtime.api.source.SchedulerConfiguration;
import org.mule.runtime.api.source.SchedulerMessageSource;
import org.mule.runtime.core.api.construct.Flow;

@Singleton
public class AgentSchedulerConfigurationFactory {
    private static final String SCHEDULER_NAME_FORMAT = "polling://%s/";

    public Scheduler create(Component component, ConfigurationComponentLocator componentLocator) {
        Component parentComponent = (Component)componentLocator.find(component.getRootContainerLocation()).orElseThrow(() -> new IllegalArgumentException("Could not create Scheduler Configuration. Flow not found."));
        if (!(component instanceof SchedulerMessageSource)) {
            String namespace = Optional.ofNullable(component.getIdentifier()).map(ComponentIdentifier::getNamespace).orElse("unknown");
            String name = Optional.ofNullable(component.getIdentifier()).map(ComponentIdentifier::getName).orElse("unknown");
            throw new UnsupportedSchedulerException(String.format("Component '%s' (namespace: %s, name: %s) is not a SchedulerMessageSource", component.getClass().getSimpleName(), namespace, name));
        }
        SchedulerMessageSource schedulerMessageSource = (SchedulerMessageSource)component;
        SchedulerConfiguration schedulerConfiguration = schedulerMessageSource.getConfiguration();
        String flowName = ((Flow)parentComponent).getName();
        if (schedulerConfiguration instanceof FixedFrequencySchedulerConfiguration) {
            FixedFrequencyScheduler scheduler = new FixedFrequencyScheduler();
            scheduler.setType(SchedulerType.FixedFrequencyScheduler);
            scheduler.setEnabled(Boolean.valueOf(schedulerMessageSource.isStarted()));
            scheduler.setName(String.format(SCHEDULER_NAME_FORMAT, flowName));
            scheduler.setFlowName(flowName);
            FixedFrequencySchedulerConfiguration fixedFrequencySchedulerConfiguration = (FixedFrequencySchedulerConfiguration)schedulerConfiguration;
            scheduler.setFrequency(Long.valueOf(fixedFrequencySchedulerConfiguration.getFrequency()));
            scheduler.setTimeUnit(fixedFrequencySchedulerConfiguration.getTimeUnit());
            scheduler.setStartDelay(Long.valueOf(fixedFrequencySchedulerConfiguration.getStartDelay()));
            return scheduler;
        }
        if (schedulerConfiguration instanceof CronSchedulerConfiguration) {
            CronScheduler scheduler = new CronScheduler();
            scheduler.setType(SchedulerType.CronScheduler);
            scheduler.setEnabled(Boolean.valueOf(schedulerMessageSource.isStarted()));
            scheduler.setName(String.format(SCHEDULER_NAME_FORMAT, flowName));
            scheduler.setFlowName(flowName);
            CronSchedulerConfiguration cronSchedulerConfiguration = (CronSchedulerConfiguration)schedulerConfiguration;
            scheduler.setTimeZone(cronSchedulerConfiguration.getTimeZone());
            scheduler.setExpression(cronSchedulerConfiguration.getExpression());
            return scheduler;
        }
        throw new IllegalArgumentException(String.format("Could not create Scheduler Configuration. Unknown Scheduler type: %s.", schedulerConfiguration.getClass()));
    }
}

