/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.repository.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.internal.DefaultRepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryServiceFactory {
    public static final String MULE_REPOSITORY_FOLDER_PROPERTY = "mule.repository.folder";
    public static final String MULE_REMOTE_REPOSITORIES_PROPERTY = "mule.repository.repositories";
    private static final String REPOSITORY_FOLDER = "repository";
    private static final Logger logger = LoggerFactory.getLogger(RepositoryServiceFactory.class);

    public RepositoryService createRepositoryService() {
        Path repositoryFolder = this.createRepositoryFolderIfDoesNotExists();
        List<RemoteRepository> remoteRepositories = this.collectRemoteRepositories();
        MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)RepositoryServiceFactory.class.getClassLoader());
        MavenClient mavenClient = mavenClientProvider.createMavenClient(this.getMavenConfiguration(repositoryFolder, remoteRepositories));
        return new DefaultRepositoryService(mavenClient);
    }

    private MavenConfiguration getMavenConfiguration(Path localRepositoryFolder, List<RemoteRepository> remoteRepositories) {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().localMavenRepositoryLocation(localRepositoryFolder.toFile());
        remoteRepositories.forEach(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).remoteRepository(arg_0));
        return mavenConfigurationBuilder.build();
    }

    private List<RemoteRepository> collectRemoteRepositories() {
        String[] remoteRepositoriesArray = System.getProperty(MULE_REMOTE_REPOSITORIES_PROPERTY, "").split(",");
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        for (String remoteRepository : remoteRepositoriesArray) {
            if (remoteRepository.trim().equals("")) continue;
            try {
                remoteRepositories.add(RemoteRepository.newRemoteRepositoryBuilder().id(remoteRepository).url(URI.create(remoteRepository.trim()).toURL()).build());
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return remoteRepositories;
    }

    private Path createRepositoryFolderIfDoesNotExists() {
        Path repositoryFolder = this.resolveRepositoryFolder();
        this.createRepositoryFolder(repositoryFolder);
        return repositoryFolder;
    }

    private void createRepositoryFolder(Path repositoryFolder) {
        if (Files.exists(repositoryFolder, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(repositoryFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create dependencies folder with path " + repositoryFolder.toAbsolutePath().toString(), e);
        }
    }

    private Path resolveRepositoryFolder() {
        String userDefinedDependenciesFolder = System.getProperty(MULE_REPOSITORY_FOLDER_PROPERTY);
        Path repositoryFolder = userDefinedDependenciesFolder != null ? Path.of(userDefinedDependenciesFolder, new String[0]) : MuleFoldersUtil.getMuleLibFolderPath().resolve("mule").resolve(REPOSITORY_FOLDER);
        logger.debug("Using dependencies folder {}", (Object)repositoryFolder.toAbsolutePath());
        return repositoryFolder;
    }
}

