/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.server;

import com.mulesoft.mule.munit.recording.server.RecordingInterceptor;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RecordingInterceptorFactory
implements ProcessorInterceptorFactory,
Lifecycle {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(RecordingInterceptorFactory.class);
    @NotNull
    @Inject
    @Named(value="_muleExpressionManager")
    private ExpressionLanguage expressionLanguage;

    public void initialise() {
        this.expressionLanguage.evaluate("null", BindingContext.builder().build());
        LOGGER.info("Initialised");
    }

    public void start() {
        LOGGER.info("Started");
    }

    public boolean intercept(ComponentLocation location) {
        switch (location.getComponentIdentifier().getType()) {
            case FLOW: 
            case ROUTE: 
            case SOURCE: {
                LOGGER.debug(String.format("Do not intercept %s", location.getLocation()));
                return false;
            }
        }
        LOGGER.debug(String.format("Intercept %s", location.getLocation()));
        return true;
    }

    public RecordingInterceptor get() {
        return new RecordingInterceptor(this.expressionLanguage);
    }

    public void stop() {
        LOGGER.info("Stopped");
    }

    public void dispose() {
        LOGGER.info("Disposed");
    }
}

