/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.server;

import com.mulesoft.mule.munit.recording.commons.wrappers.Container;
import com.mulesoft.mule.munit.recording.commons.wrappers.RecordedEvent;
import com.mulesoft.mule.munit.recording.commons.wrappers.RecordedTypedValue;
import com.mulesoft.mule.munit.recording.server.RecordingServer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordingInterceptor
implements ProcessorInterceptor {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ProcessorInterceptor.class);
    private static final RecordingServer SERVER = RecordingServer.getInstance();
    private final ExpressionLanguage expressionLanguage;

    RecordingInterceptor(@NotNull ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = Objects.requireNonNull(expressionLanguage, "The expression language may not be null");
    }

    public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
        try {
            String flow = location.getRootContainerName();
            String processor = location.getLocation();
            Container response = SERVER.ask(this.createCheck(event, flow, processor)).orElseThrow(() -> new IllegalStateException("There was no response from the client"));
            if (response.type() == Container.Type.YES) {
                LOGGER.debug(String.format("Processing %s", processor));
                SERVER.send(this.createBefore(event, flow, processor));
            } else {
                LOGGER.debug(String.format("Skipping %s", processor));
            }
        }
        catch (Exception cause) {
            LOGGER.error("There was a problem processing the interception", (Throwable)cause);
            throw cause;
        }
    }

    public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
        try {
            String flow = location.getRootContainerName();
            String processor = location.getLocation();
            Container response = SERVER.ask(this.createCheck(event, flow, processor)).orElseThrow(() -> new IllegalStateException("There was no response from the client"));
            if (response.type() == Container.Type.YES) {
                LOGGER.debug(String.format("Processing %s", processor));
                if (thrown.isPresent()) {
                    SERVER.send(this.createAfter(event, flow, processor, thrown.get()));
                } else {
                    SERVER.send(this.createAfter(event, flow, processor));
                }
            } else {
                LOGGER.debug(String.format("Skipping %s", processor));
            }
        }
        catch (Exception cause) {
            LOGGER.error("There was a problem processing the interception", (Throwable)cause);
            throw cause;
        }
    }

    private Container createCheck(InterceptionEvent event, String flow, String processor) {
        return new Container(Container.Type.CHECK, new Container.Entry[]{new Container.Entry(Container.Key.EVENT_ID, (Object)event.getCorrelationId()), new Container.Entry(Container.Key.FLOW, (Object)flow), new Container.Entry(Container.Key.PROCESSOR, (Object)processor)});
    }

    private Container createBefore(InterceptionEvent event, String flow, String processor) {
        return new Container(Container.Type.BEFORE, new Container.Entry[]{new Container.Entry(Container.Key.EVENT, (Object)new RecordedEvent(this.expressionLanguage, (Event)event)), new Container.Entry(Container.Key.EVENT_ID, (Object)event.getCorrelationId()), new Container.Entry(Container.Key.FLOW, (Object)flow), new Container.Entry(Container.Key.PROCESSOR, (Object)processor)});
    }

    private Container createAfter(InterceptionEvent event, String flow, String processor) {
        return new Container(Container.Type.AFTER, new Container.Entry[]{new Container.Entry(Container.Key.EVENT, (Object)new RecordedEvent(this.expressionLanguage, (Event)event)), new Container.Entry(Container.Key.EVENT_ID, (Object)event.getCorrelationId()), new Container.Entry(Container.Key.FLOW, (Object)flow), new Container.Entry(Container.Key.PROCESSOR, (Object)processor)});
    }

    private Container createAfter(InterceptionEvent event, String flow, String processor, Throwable thrown) {
        return new Container(Container.Type.AFTER, new Container.Entry[]{new Container.Entry(Container.Key.EVENT, (Object)new RecordedEvent(this.expressionLanguage, (Event)event)), new Container.Entry(Container.Key.EVENT_ID, (Object)event.getCorrelationId()), new Container.Entry(Container.Key.FLOW, (Object)flow), new Container.Entry(Container.Key.PROCESSOR, (Object)processor), new Container.Entry(Container.Key.THROWABLE, (Object)RecordedTypedValue.valueOf((ExpressionLanguage)this.expressionLanguage, (TypedValue)TypedValue.of((Object)thrown)))});
    }
}

