/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.p2.touchpoints.installruntime;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.mule.tooling.p2.touchpoints.TouchpointsActivator;
import org.mule.tooling.p2.touchpoints.installruntime.InstallFeatureAsRootOperation;

public class InstallRuntimeAction
extends ProvisioningAction {
    private static final String SELECT_FEATURES_QUERY = "$0.select ( x | x.properties['org.eclipse.equinox.p2.type.group'] == true)";
    private static final String PRODUCT_TRANSITIVE_DEPENDENCIES_QUERY = "$0.traverse(parent | parent.requirements.collect(rc | select(iu | iu ~= rc)).flatten())";
    private static final String SERVER_ID_PREFIX = "org.mule.tooling.extension.server.";
    private static final String SERVER_ID_SUFFIX = ".ee.feature.group";
    private static final String EXAMPLE_RUNTIME_VERSION = "0.00.0";
    private static final int SERVER_ID_LENGTH = "org.mule.tooling.extension.server.0.00.0.ee.feature.group".length();

    public InstallRuntimeAction() {
        TouchpointsActivator.debug(() -> "Created touchpoint action " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public IStatus execute(Map<String, Object> parameters) {
        TouchpointsActivator.debug(() -> "Executing " + ((Object)((Object)this)).getClass().getSimpleName() + " touchpoint");
        TouchpointsActivator.debug(() -> this.getParametersString(parameters));
        boolean isUpgrade = this.isUpgrade(parameters);
        if (isUpgrade) {
            TouchpointsActivator.debug(() -> "Upgrade detected, running tuchpoint action");
            return this.executeOnUpgrade(parameters);
        }
        TouchpointsActivator.debug(() -> "Not an upgrade, skipping touchpoint");
        return Status.OK_STATUS;
    }

    private boolean isUpgrade(Map<String, Object> parameters) {
        boolean isUpgrade = false;
        Object operand = parameters.get("operand");
        if (operand instanceof InstallableUnitOperand) {
            isUpgrade = ((InstallableUnitOperand)operand).first() != null;
        }
        return isUpgrade;
    }

    private IStatus executeOnUpgrade(Map<String, Object> parameters) {
        IProvisioningAgent agent = (IProvisioningAgent)this.getParameter("agent", parameters);
        IProfile profile = (IProfile)this.getParameter("profile", parameters);
        ProvisioningContext context = (ProvisioningContext)this.getParameter("context", parameters);
        IStatus result = Status.CANCEL_STATUS;
        if (agent != null && profile != null && context != null) {
            result = this.executeOnUpgrade(profile, agent, context);
        }
        return result;
    }

    private IStatus executeOnUpgrade(IProfile profile, IProvisioningAgent agent, ProvisioningContext context) {
        Optional<IInstallableUnit> maybeServerFeature = this.getServerToInstall(profile);
        IStatus result = Status.CANCEL_STATUS;
        if (maybeServerFeature.isPresent()) {
            IInstallableUnit serverFeature = maybeServerFeature.get();
            TouchpointsActivator.debug(() -> "Resolved server feature to install: " + String.valueOf(serverFeature));
            result = this.resolveAndQueueProvisioningJob(serverFeature, profile, agent, context);
        } else {
            TouchpointsActivator.debug(() -> "No new server to install, product features: \n" + String.valueOf(this.getProductFeatures((IQueryable<IInstallableUnit>)profile)));
            result = Status.OK_STATUS;
        }
        return result;
    }

    private IStatus resolveAndQueueProvisioningJob(IInstallableUnit serverFeature, IProfile profile, IProvisioningAgent agent, ProvisioningContext context) {
        IStatus result = Status.CANCEL_STATUS;
        NullProgressMonitor monitor = new NullProgressMonitor();
        TouchpointsActivator.debug(() -> "Resolving plan for installing: " + String.valueOf(serverFeature));
        InstallOperation installOperation = this.getInstallOperation(serverFeature, agent, profile, context);
        if (this.resolveProvisioningPlan(serverFeature, installOperation, (IProgressMonitor)monitor).isOK()) {
            TouchpointsActivator.debug(() -> "Resolved plan for installing: " + String.valueOf(serverFeature));
            TouchpointsActivator.debug(() -> "Resolving provisioning job for installing: " + String.valueOf(serverFeature));
            ProvisioningJob provisioningJob = installOperation.getProvisioningJob((IProgressMonitor)monitor);
            if (provisioningJob != null) {
                this.queueProvisioningJobAfterUpgrade(serverFeature, provisioningJob, (IProgressMonitor)monitor);
                result = Status.OK_STATUS;
            } else {
                this.logError("Failed to get provisioning job for installing: " + String.valueOf(serverFeature));
            }
        } else {
            this.logError("Failed to resolve plan for installing: " + String.valueOf(serverFeature));
        }
        return result;
    }

    private <T> T getParameter(String key, Map<String, Object> parameters) {
        Object value = parameters.get(key);
        if (value == null) {
            TouchpointsActivator.logError("Missing required touchpoint action parameter \"" + key + "\". Actual parameters:\n" + this.getParametersString(parameters), new IllegalArgumentException("expected touchpoint parameter " + key));
        }
        return (T)value;
    }

    private InstallOperation getInstallOperation(IInstallableUnit serverFeature, IProvisioningAgent agent, IProfile profile, ProvisioningContext context) {
        InstallFeatureAsRootOperation installOperation = new InstallFeatureAsRootOperation(profile, agent, Arrays.asList(serverFeature), new ProvisioningSession(agent));
        installOperation.setProfileId(profile.getProfileId());
        installOperation.setProvisioningContext(context);
        return installOperation;
    }

    private void queueProvisioningJobAfterUpgrade(final IInstallableUnit serverFeature, final ProvisioningJob provisioningJob, final IProgressMonitor monitor) {
        Job currentJob = Job.getJobManager().currentJob();
        currentJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                TouchpointsActivator.debug(() -> "Finished original update job, running provisioning job in modal");
                try {
                    provisioningJob.runModal(monitor);
                    TouchpointsActivator.debug(() -> "Successfully installed: " + String.valueOf(serverFeature));
                }
                catch (Throwable e) {
                    TouchpointsActivator.logError("Error running provisioning job installing: " + String.valueOf(serverFeature), e);
                }
            }
        });
    }

    private IStatus resolveProvisioningPlan(IInstallableUnit serverFeature, InstallOperation op, IProgressMonitor monitor) {
        IStatus result = Status.CANCEL_STATUS;
        try {
            result = op.resolveModal(monitor);
        }
        catch (Throwable e) {
            TouchpointsActivator.logError("Error resolving provisioning operation installing: " + String.valueOf(serverFeature), e);
        }
        return result != null ? result : Status.CANCEL_STATUS;
    }

    private Optional<IInstallableUnit> getServerToInstall(IProfile profile) {
        Set<IInstallableUnit> features = this.getProductFeatures((IQueryable<IInstallableUnit>)profile);
        Set rootFeatures = profile.query((IQuery)new UserVisibleRootQuery(), (IProgressMonitor)new NullProgressMonitor()).toSet();
        TouchpointsActivator.debug(() -> "Root features " + rootFeatures.stream().map(IVersionedId::getId).collect(Collectors.joining(", ")));
        return features.stream().filter(feature -> this.isMuleServerFeature((IInstallableUnit)feature)).findFirst().flatMap(feature -> {
            boolean isRootFeature = rootFeatures.stream().anyMatch(iu -> iu.getId().equals(feature.getId()));
            if (!isRootFeature) {
                return Optional.of(feature);
            }
            return Optional.empty();
        });
    }

    private boolean isMuleServerFeature(IInstallableUnit feature) {
        String id = feature.getId();
        return id != null && id.startsWith(SERVER_ID_PREFIX) && id.endsWith(SERVER_ID_SUFFIX) && SERVER_ID_LENGTH >= id.length();
    }

    private String getParametersString(Map<String, Object> parameters) {
        String parametersString = parameters.entrySet().stream().map(entry -> {
            Object value = entry.getValue();
            String className = value != null ? value.getClass().getSimpleName() : "null value";
            StringBuilder stringBuilder = new StringBuilder("Touchpoint parameter ").append("key: ").append((String)entry.getKey()).append(", value class: ").append(className).append(", value: ").append(value);
            return stringBuilder.toString();
        }).collect(Collectors.joining(System.lineSeparator()));
        return parametersString;
    }

    public IStatus undo(Map<String, Object> parameters) {
        String touchpointName = ((Object)((Object)this)).getClass().getSimpleName();
        TouchpointsActivator.debug(() -> "Called undo on touchpoint " + touchpointName);
        TouchpointsActivator.debug(() -> this.getParametersString(parameters));
        TouchpointsActivator.logInfo("Undo not implemented for touchpoint " + touchpointName);
        return Status.OK_STATUS;
    }

    private Set<IInstallableUnit> getProductFeatures(IQueryable<IInstallableUnit> p2Profile) {
        Set set;
        long ini = System.currentTimeMillis();
        try {
            Set productUnits = p2Profile.query(QueryUtil.createIUProductQuery(), null).toSet();
            IQuery productTransitiveDependenciesQuery = QueryUtil.createQuery((String)PRODUCT_TRANSITIVE_DEPENDENCIES_QUERY, (Object[])new Object[]{productUnits});
            Set allTransitiveProductDependentUnits = p2Profile.query(productTransitiveDependenciesQuery, null).toSet();
            IQuery productFeaturesQuery = QueryUtil.createQuery((String)SELECT_FEATURES_QUERY, (Object[])new Object[]{allTransitiveProductDependentUnits});
            Set productFeatures = p2Profile.query(productFeaturesQuery, null).toSet();
            TouchpointsActivator.debug(() -> "Product features: " + productFeatures.stream().map(feat -> feat.getId()).collect(Collectors.joining(", ")));
            set = productFeatures;
        }
        catch (Throwable throwable) {
            TouchpointsActivator.debug(() -> "getProductFeatures took: " + (System.currentTimeMillis() - ini) + " msec");
            throw throwable;
        }
        TouchpointsActivator.debug(() -> "getProductFeatures took: " + (System.currentTimeMillis() - ini) + " msec");
        return set;
    }

    private void logError(String message) {
        TouchpointsActivator.logError(message, new IllegalStateException().fillInStackTrace());
    }
}

