/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.p2.touchpoints.installruntime;

import java.lang.reflect.Field;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.mule.tooling.p2.touchpoints.TouchpointsActivator;

public class InstallFeatureAsRootOperation
extends InstallOperation {
    private static final String REQUEST_FIELD_NAME = "request";
    private final IProfile profile;
    private final IProvisioningAgent provisioningAgent;

    public InstallFeatureAsRootOperation(IProfile profile, IProvisioningAgent provisioningAgent, Collection<IInstallableUnit> toInstall, ProvisioningSession session) {
        super(session, toInstall);
        this.profile = profile;
        this.provisioningAgent = provisioningAgent;
    }

    protected void computeProfileChangeRequest(MultiStatus status, IProgressMonitor monitor) {
        IPlanner planner = (IPlanner)this.provisioningAgent.getService(IPlanner.SERVICE_NAME);
        IProfileChangeRequest request = planner.createChangeRequest(this.profile);
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)this.toInstall.size());
        for (IInstallableUnit entryToInstall : this.toInstall) {
            request.add(entryToInstall);
            request.setInstallableUnitProfileProperty(entryToInstall, "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
            submonitor.worked(1);
        }
        this.setRequest(request);
        submonitor.done();
    }

    private void setRequest(IProfileChangeRequest request) {
        InstallFeatureAsRootOperation.setField(ProfileChangeOperation.class, (Object)this, REQUEST_FIELD_NAME, request);
    }

    private static void setField(Class<?> type, Object object, String fieldName, Object value) {
        block8: {
            try {
                Field field = InstallFeatureAsRootOperation.searchFieldByName(type, fieldName);
                if (field != null) {
                    boolean originallyAccessible = field.isAccessible();
                    if (!originallyAccessible) {
                        field.setAccessible(true);
                    }
                    try {
                        field.set(object, value);
                        break block8;
                    }
                    finally {
                        if (!originallyAccessible) {
                            field.setAccessible(false);
                        }
                    }
                }
                throw new IllegalArgumentException("Could not find field " + fieldName + " in class " + type.getCanonicalName());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                TouchpointsActivator.logError("Error setting field " + fieldName + " in class " + type.getCanonicalName(), e);
                throw new RuntimeException(e);
            }
        }
    }

    private static Field searchFieldByName(Class<?> className, String fieldName) {
        Field declaredField = null;
        try {
            declaredField = className.getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            TouchpointsActivator.logError("Error while using reflection over " + className.getName(), e);
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        if (declaredField == null && className.getSuperclass() != null) {
            return InstallFeatureAsRootOperation.searchFieldByName(className.getSuperclass(), fieldName);
        }
        return declaredField;
    }
}

