/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.flatfile.extension.types;

import com.google.common.base.Optional;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.schema.fftypes.DemoSupport;
import com.mulesoft.flatfile.schema.fftypes.StringFormat$;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.flatfile.FieldFormatAnnotation;
import org.mule.tooling.ui.flatfile.extension.FixedWidthTableElement;
import org.mule.tooling.ui.flatfile.extension.types.FixedWidthTypeEditor;
import org.mule.tooling.ui.utils.ControlFactory;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;

public class StringFixedWidthTypeEditor
extends Composite
implements FixedWidthTypeEditor {
    private Spinner widthSpinner;
    private Button alignLeft;
    private Button alignRight;
    private StyledText previewExample;
    private ContentType<MetadataType> type;
    private FixedWidthTableElement<?> element;
    private String previewSampleInput = "ABC";

    public StringFixedWidthTypeEditor(Composite parent, FixedWidthTableElement<?> element, ContentType<MetadataType> type) {
        super(parent, 0);
        this.element = element;
        this.type = type;
        this.createControl();
        this.initialize(element);
    }

    @Override
    public ContentType<MetadataType> getType() {
        return this.type;
    }

    protected void createControl() {
        PreviewListener previewListener = new PreviewListener();
        this.setLayout((Layout)FormLayoutUtils.formLayout());
        ControlFactory controls = ControlFactory.createChildsOf((Composite)this);
        this.widthSpinner = controls.spinner();
        this.widthSpinner.setMinimum(1);
        this.widthSpinner.addSelectionListener((SelectionListener)previewListener);
        FormLayoutUtils.attach((Control)this.widthSpinner).top().left(50);
        FormLayoutUtils.attach((Control)controls.label("Width")).alignMiddle((Control)this.widthSpinner).left();
        Label alignLabel = controls.label("Align");
        this.alignLeft = controls.radio("Left", (SelectionListener)previewListener);
        this.alignRight = controls.radio("Right", (SelectionListener)previewListener);
        FormLayoutUtils.attach((Control)alignLabel).leftFrom((Control)this.widthSpinner, 20).alignMiddle((Control)this.widthSpinner);
        FormLayoutUtils.attach((Control)this.alignLeft).leftFrom((Control)alignLabel, 2).top();
        FormLayoutUtils.attach((Control)this.alignRight).leftFrom((Control)this.alignLeft, 2).top();
        Label previewLabel = controls.label("Preview");
        Label editHint = controls.label("Double click to edit sample");
        editHint.setForeground(Display.getCurrent().getSystemColor(33));
        FormLayoutUtils.attach((Control)previewLabel).topFrom((Control)this.widthSpinner, 12);
        FormLayoutUtils.attach((Control)editHint).topFrom((Control)this.widthSpinner, 12).right();
        this.previewExample = controls.styledText();
        this.previewExample.addMouseListener((MouseListener)new PreviewMouseAdapter());
        this.previewExample.addKeyListener((KeyListener)new PreviewKeyAdapter());
        this.previewExample.setEditable(false);
        this.previewExample.setToolTipText("Sample value - Double click to edit");
        FormLayoutUtils.attach((Control)this.previewExample).topFrom((Control)previewLabel, 5).left().right();
    }

    @Override
    public void refresh() {
        this.initialize(this.element);
    }

    private void initialize(FixedWidthTableElement<?> element) {
        this.widthSpinner.setSelection(element.getWidth());
        this.alignLeft.setSelection(false);
        this.alignRight.setSelection(false);
        Optional<TypeFormatConstants.FillMode> alignMaybe = element.getAlign();
        this.configureAlignment(alignMaybe.isPresent() ? (TypeFormatConstants.FillMode)alignMaybe.get() : null);
        this.previewExample.setText("\n" + this.applyFormats(this.previewSampleInput) + "\n");
    }

    private void configureAlignment(TypeFormatConstants.FillMode fillMode) {
        switch (fillMode) {
            case LEFT: {
                this.alignLeft.setSelection(true);
                break;
            }
            case RIGHT: {
                this.alignRight.setSelection(true);
                break;
            }
            default: {
                this.alignLeft.setSelection(true);
                this.alignRight.setSelection(false);
            }
        }
    }

    private TypeFormatConstants.FillMode getAlignment() {
        return this.alignLeft.getSelection() ? TypeFormatConstants.FillMode.LEFT : TypeFormatConstants.FillMode.RIGHT;
    }

    private String applyFormats(String input) {
        try {
            TypeFormatConstants.FillMode fillMode = this.getAlignment();
            TypeFormat formatter = StringFormat$.MODULE$.apply(this.widthSpinner.getSelection(), fillMode);
            String previewResult = DemoSupport.writeString((Object)input, (TypeFormat)formatter);
            previewResult = previewResult.replace(' ', '.');
            return previewResult;
        }
        catch (Exception e) {
            return "Preview Error: " + e.getMessage();
        }
    }

    @Override
    public FixedWidthTableElement<?> getResult() {
        FieldFormatAnnotation formats = new FieldFormatAnnotation(Integer.valueOf(this.widthSpinner.getSelection()));
        formats.withAlign(this.getAlignment().name());
        return new FixedWidthTableElement<MetadataType>(this.element.getQname(), this.type, formats);
    }

    private final class PreviewKeyAdapter
    extends KeyAdapter {
        private PreviewKeyAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\r') {
                StringFixedWidthTypeEditor.this.previewExample.setEditable(false);
                StringFixedWidthTypeEditor.this.previewSampleInput = StringFixedWidthTypeEditor.this.previewExample.getText().replaceAll("\\r\\n|\\r|\\n", "");
                StringFixedWidthTypeEditor.this.previewExample.setText("\n" + StringFixedWidthTypeEditor.this.applyFormats(StringFixedWidthTypeEditor.this.previewSampleInput) + "\n");
            }
        }
    }

    private final class PreviewListener
    extends SelectionAdapter {
        private PreviewListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            StringFixedWidthTypeEditor.this.previewExample.setText("\n" + StringFixedWidthTypeEditor.this.applyFormats(StringFixedWidthTypeEditor.this.previewSampleInput) + "\n");
        }
    }

    private final class PreviewMouseAdapter
    extends MouseAdapter {
        private PreviewMouseAdapter() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            StringFixedWidthTypeEditor.this.previewExample.setText(StringFixedWidthTypeEditor.this.previewSampleInput);
            StringFixedWidthTypeEditor.this.previewExample.setEditable(true);
        }
    }
}

