/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.flatfile.extension.types;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.schema.fftypes.DemoSupport;
import com.mulesoft.flatfile.schema.fftypes.IntegerFormat$;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.flatfile.FieldFormatAnnotation;
import org.mule.tooling.ui.flatfile.extension.FixedWidthTableElement;
import org.mule.tooling.ui.flatfile.extension.types.FixedWidthTypeEditor;
import org.mule.tooling.ui.utils.ControlFactory;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;

public class IntegerFixedWidthTypeEditor
extends Composite
implements FixedWidthTypeEditor {
    private Spinner widthSpinner;
    private Combo localeCombo;
    private Button alignLeft;
    private Button alignRight;
    private Button padWithZeroes;
    private Button formatPattern;
    private StyledText pattern;
    private StyledText previewExample;
    private ContentType<MetadataType> type;
    private FixedWidthTableElement<?> element;
    private String previewSampleInput = "123";
    private int indexDefaultLocale;

    public IntegerFixedWidthTypeEditor(Composite parent, FixedWidthTableElement<?> element, ContentType<MetadataType> type) {
        super(parent, 0);
        this.element = element;
        this.type = type;
        this.createControl();
        this.initialize(element);
    }

    @Override
    public ContentType<MetadataType> getType() {
        return this.type;
    }

    protected void createControl() {
        PreviewListener previewListener = new PreviewListener();
        LeftAlignListener leftAlignListener = new LeftAlignListener(previewListener);
        PaddingListener paddingListener = new PaddingListener(previewListener);
        this.setLayout((Layout)FormLayoutUtils.formLayout());
        ControlFactory controls = ControlFactory.createChildsOf((Composite)this);
        this.widthSpinner = controls.spinner();
        this.widthSpinner.setMinimum(1);
        this.widthSpinner.addSelectionListener((SelectionListener)previewListener);
        FormLayoutUtils.attach((Control)this.widthSpinner).top().left(50);
        FormLayoutUtils.attach((Control)controls.label("Width")).alignMiddle((Control)this.widthSpinner).left();
        Label alignLabel = controls.label("Align");
        this.alignLeft = controls.radio("Left", (SelectionListener)leftAlignListener);
        this.alignRight = controls.radio("Right", (SelectionListener)previewListener);
        this.padWithZeroes = controls.check("Pad with zeroes", (SelectionListener)paddingListener);
        FormLayoutUtils.attach((Control)alignLabel).leftFrom((Control)this.widthSpinner, 20).alignMiddle((Control)this.widthSpinner);
        FormLayoutUtils.attach((Control)this.alignLeft).leftFrom((Control)alignLabel, 2).top();
        FormLayoutUtils.attach((Control)this.alignRight).leftFrom((Control)this.alignLeft, 2).top();
        FormLayoutUtils.attach((Control)this.padWithZeroes).leftFrom((Control)this.alignRight, 2).top();
        this.formatPattern = controls.check("Format pattern", (SelectionListener)new FormatPatternListener(previewListener));
        this.pattern = controls.styledText(2052, (SelectionListener)previewListener);
        FormLayoutUtils.attach((Control)this.formatPattern).topFrom((Control)this.widthSpinner, 12);
        FormLayoutUtils.attach((Control)this.pattern).topFrom((Control)this.formatPattern, 12);
        Label locale = controls.label("Locale");
        FormLayoutUtils.attach((Control)locale).topFrom((Control)this.formatPattern, 12).leftFrom((Control)this.pattern, 2).bottomFrom((Control)this.pattern);
        this.localeCombo = controls.dropdown(this.getLocales(), (SelectionListener)previewListener);
        FormLayoutUtils.attach((Control)this.localeCombo).topFrom((Control)this.formatPattern, 12).leftFrom((Control)locale, 2).bottomFrom((Control)this.pattern);
        Label previewLabel = controls.label("Preview");
        Label editHint = controls.label("Double click to edit sample");
        editHint.setForeground(Display.getCurrent().getSystemColor(33));
        FormLayoutUtils.attach((Control)previewLabel).topFrom((Control)this.pattern, 12);
        FormLayoutUtils.attach((Control)editHint).topFrom((Control)this.pattern, 12).right();
        this.previewExample = controls.styledText();
        this.previewExample.addMouseListener((MouseListener)new PreviewMouseAdapter());
        this.previewExample.addKeyListener((KeyListener)new PreviewKeyAdapter());
        this.previewExample.setEditable(false);
        this.previewExample.setToolTipText("Sample value - Double click to edit");
        FormLayoutUtils.attach((Control)this.previewExample).topFrom((Control)previewLabel, 5).left().right();
    }

    @Override
    public void refresh() {
        this.initialize(this.element);
    }

    private void initialize(FixedWidthTableElement<?> element) {
        this.widthSpinner.setSelection(element.getWidth());
        this.alignLeft.setSelection(false);
        this.alignRight.setSelection(false);
        this.padWithZeroes.setSelection(false);
        this.pattern.setEnabled(false);
        this.localeCombo.setEnabled(false);
        this.pattern.setText("");
        this.localeCombo.select(this.indexDefaultLocale);
        Optional<TypeFormatConstants.FillMode> alignMaybe = element.getAlign();
        Optional<String> patternMaybe = element.getPattern();
        Optional<Locale> localeMaybe = element.getLocale();
        this.configureAlignment(alignMaybe.isPresent() ? (TypeFormatConstants.FillMode)alignMaybe.get() : null);
        this.configurePattern(patternMaybe, localeMaybe);
        this.previewExample.setText("\n" + this.applyFormats(this.previewSampleInput) + "\n");
    }

    private void configureAlignment(TypeFormatConstants.FillMode fillMode) {
        switch (fillMode) {
            case LEFT: {
                this.alignLeft.setSelection(true);
                break;
            }
            case RIGHT: {
                this.alignRight.setSelection(true);
                break;
            }
            case ZEROES: {
                this.alignRight.setSelection(true);
                this.padWithZeroes.setSelection(true);
                break;
            }
            default: {
                this.alignLeft.setSelection(false);
                this.alignRight.setSelection(true);
                this.padWithZeroes.setSelection(false);
            }
        }
    }

    private void configurePattern(Optional<String> patternMaybe, Optional<Locale> localeMaybe) {
        if (localeMaybe.isPresent()) {
            this.pattern.setEnabled(true);
            this.localeCombo.setEnabled(true);
            this.formatPattern.setSelection(true);
            Locale locale = (Locale)localeMaybe.get();
            this.selectType(this.localeCombo, locale.toString());
            this.pattern.setText((String)patternMaybe.get());
        }
    }

    private void selectType(Combo typeCombo, String type) {
        int index = 0;
        String[] stringArray = typeCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (StringUtils.equals((String)item, (String)type)) {
                typeCombo.select(index);
                break;
            }
            ++index;
            ++n2;
        }
    }

    private TypeFormatConstants.FillMode getAlignment() {
        return this.padWithZeroes.getSelection() ? TypeFormatConstants.FillMode.ZEROES : (this.alignLeft.getSelection() ? TypeFormatConstants.FillMode.LEFT : TypeFormatConstants.FillMode.RIGHT);
    }

    private String applyFormats(String input) {
        try {
            TypeFormatConstants.FillMode fillMode = this.getAlignment();
            TypeFormat formatter = null;
            formatter = this.formatPattern.getSelection() ? IntegerFormat$.MODULE$.apply(this.widthSpinner.getSelection(), this.pattern.getText(), LocaleUtils.toLocale((String)this.localeCombo.getText()), fillMode) : IntegerFormat$.MODULE$.apply(this.widthSpinner.getSelection(), TypeFormatConstants.NumberSign.OPTIONAL, fillMode);
            String previewResult = DemoSupport.writeString((Object)Long.valueOf(input), (TypeFormat)formatter);
            previewResult = TypeFormatConstants.FillMode.ZEROES == fillMode ? previewResult.replace(' ', '0') : previewResult.replace(' ', '.');
            return previewResult;
        }
        catch (Exception e) {
            return "Preview Error: " + e.getMessage();
        }
    }

    private List<String> getLocales() {
        ArrayList locales = Lists.newArrayList();
        int index = 0;
        this.indexDefaultLocale = 0;
        String defaultLocale = Locale.getDefault().toString();
        List<Locale> availableLocales = Arrays.asList(DateFormat.getAvailableLocales());
        Collections.sort(availableLocales, new LocaleComparator());
        for (Locale locale : availableLocales) {
            String localeString = locale.toString();
            if (localeString.isEmpty()) continue;
            locales.add(localeString);
            if (localeString.equals(defaultLocale)) {
                this.indexDefaultLocale = index;
            }
            ++index;
        }
        return locales;
    }

    @Override
    public FixedWidthTableElement<?> getResult() {
        FieldFormatAnnotation formats = new FieldFormatAnnotation(Integer.valueOf(this.widthSpinner.getSelection()));
        formats.withAlign(this.getAlignment().name());
        if (this.formatPattern.getSelection()) {
            formats.withPattern(this.pattern.getText()).withLocale(this.localeCombo.getText());
        } else {
            formats.withNumberSign(TypeFormatConstants.NumberSign.OPTIONAL.name());
        }
        return new FixedWidthTableElement<MetadataType>(this.element.getQname(), this.type, formats);
    }

    private final class FormatPatternListener
    extends SelectionAdapter {
        private SelectionAdapter previewListener;

        public FormatPatternListener(SelectionAdapter previewListener) {
            this.previewListener = previewListener;
        }

        public void widgetSelected(SelectionEvent e) {
            boolean isSelected = ((Button)e.getSource()).getSelection();
            IntegerFixedWidthTypeEditor.this.pattern.setEnabled(isSelected);
            IntegerFixedWidthTypeEditor.this.localeCombo.setEnabled(isSelected);
            if (isSelected) {
                IntegerFixedWidthTypeEditor.this.padWithZeroes.setSelection(!isSelected);
            } else {
                IntegerFixedWidthTypeEditor.this.pattern.setText("");
            }
            this.previewListener.widgetSelected(e);
        }
    }

    private final class LeftAlignListener
    extends SelectionAdapter {
        private SelectionAdapter previewListener;

        public LeftAlignListener(SelectionAdapter previewListener) {
            this.previewListener = previewListener;
        }

        public void widgetSelected(SelectionEvent e) {
            boolean isSelected = ((Button)e.getSource()).getSelection();
            if (isSelected) {
                IntegerFixedWidthTypeEditor.this.padWithZeroes.setSelection(!isSelected);
            }
            this.previewListener.widgetSelected(e);
        }
    }

    private static final class LocaleComparator
    implements Comparator<Locale> {
        private LocaleComparator() {
        }

        @Override
        public int compare(Locale locale1, Locale locale2) {
            return locale1.toString().compareTo(locale2.toString());
        }
    }

    private final class PaddingListener
    extends SelectionAdapter {
        private SelectionAdapter previewListener;

        public PaddingListener(SelectionAdapter previewListener) {
            this.previewListener = previewListener;
        }

        public void widgetSelected(SelectionEvent e) {
            boolean isSelected = ((Button)e.getSource()).getSelection();
            if (isSelected) {
                IntegerFixedWidthTypeEditor.this.alignLeft.setSelection(!isSelected);
                IntegerFixedWidthTypeEditor.this.alignRight.setSelection(isSelected);
            }
            IntegerFixedWidthTypeEditor.this.pattern.setText("");
            this.previewListener.widgetSelected(e);
        }
    }

    private final class PreviewKeyAdapter
    extends KeyAdapter {
        private PreviewKeyAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\r') {
                IntegerFixedWidthTypeEditor.this.previewExample.setEditable(false);
                IntegerFixedWidthTypeEditor.this.previewSampleInput = IntegerFixedWidthTypeEditor.this.previewExample.getText().replaceAll("\\r\\n|\\r|\\n", "");
                IntegerFixedWidthTypeEditor.this.previewExample.setText("\n" + IntegerFixedWidthTypeEditor.this.applyFormats(IntegerFixedWidthTypeEditor.this.previewSampleInput) + "\n");
            }
        }
    }

    private final class PreviewListener
    extends SelectionAdapter {
        private PreviewListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IntegerFixedWidthTypeEditor.this.previewExample.setText("\n" + IntegerFixedWidthTypeEditor.this.applyFormats(IntegerFixedWidthTypeEditor.this.previewSampleInput) + "\n");
        }
    }

    private final class PreviewMouseAdapter
    extends MouseAdapter {
        private PreviewMouseAdapter() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            IntegerFixedWidthTypeEditor.this.previewExample.setText(IntegerFixedWidthTypeEditor.this.previewSampleInput);
            IntegerFixedWidthTypeEditor.this.previewExample.setEditable(true);
        }
    }
}

