/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.flatfile.extension.types;

import com.google.common.base.Optional;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.schema.fftypes.DemoSupport;
import com.mulesoft.flatfile.schema.fftypes.LocalDateFormat$;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.flatfile.FieldFormatAnnotation;
import org.mule.tooling.ui.flatfile.extension.FixedWidthTableElement;
import org.mule.tooling.ui.flatfile.extension.types.FixedWidthTypeEditor;
import org.mule.tooling.ui.utils.ControlFactory;
import org.mule.tooling.ui.widgets.treetable.ContentType;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;

public class DateFixedWidthTypeEditor
extends Composite
implements FixedWidthTypeEditor {
    private Spinner widthSpinner;
    private Button alignLeft;
    private Button alignRight;
    private Button formatPattern;
    private StyledText pattern;
    private StyledText previewExample;
    private ContentType<MetadataType> type;
    private FixedWidthTableElement<?> element;

    public DateFixedWidthTypeEditor(Composite parent, FixedWidthTableElement<?> element, ContentType<MetadataType> type) {
        super(parent, 0);
        this.element = element;
        this.type = type;
        this.createControl();
        this.initialize(element);
    }

    @Override
    public ContentType<MetadataType> getType() {
        return this.type;
    }

    protected void createControl() {
        PreviewListener previewListener = new PreviewListener();
        this.setLayout((Layout)FormLayoutUtils.formLayout());
        ControlFactory controls = ControlFactory.createChildsOf((Composite)this);
        this.widthSpinner = controls.spinner();
        this.widthSpinner.setMinimum(1);
        this.widthSpinner.addSelectionListener((SelectionListener)previewListener);
        FormLayoutUtils.attach((Control)this.widthSpinner).top().left(50);
        FormLayoutUtils.attach((Control)controls.label("Width")).alignMiddle((Control)this.widthSpinner).left();
        Label alignLabel = controls.label("Align");
        this.alignLeft = controls.radio("Left", (SelectionListener)previewListener);
        this.alignRight = controls.radio("Right", (SelectionListener)previewListener);
        FormLayoutUtils.attach((Control)alignLabel).leftFrom((Control)this.widthSpinner, 20).alignMiddle((Control)this.widthSpinner);
        FormLayoutUtils.attach((Control)this.alignLeft).leftFrom((Control)alignLabel, 2).top();
        FormLayoutUtils.attach((Control)this.alignRight).leftFrom((Control)this.alignLeft, 2).top();
        this.formatPattern = controls.check("Format pattern", (SelectionListener)new FormatPatternListener(previewListener));
        this.pattern = controls.styledText(2052, (SelectionListener)previewListener);
        FormLayoutUtils.attach((Control)this.formatPattern).topFrom((Control)this.widthSpinner, 12);
        FormLayoutUtils.attach((Control)this.pattern).topFrom((Control)this.formatPattern, 12);
        Label locale = controls.label("Locale");
        FormLayoutUtils.attach((Control)locale).topFrom((Control)this.formatPattern, 12).leftFrom((Control)this.pattern, 2).bottomFrom((Control)this.pattern);
        Label previewLabel = controls.label("Preview");
        Label previewHint = controls.label("Current date is used for preview");
        previewHint.setForeground(Display.getCurrent().getSystemColor(33));
        FormLayoutUtils.attach((Control)previewLabel).topFrom((Control)this.pattern, 12);
        FormLayoutUtils.attach((Control)previewHint).topFrom((Control)this.pattern, 12).right();
        this.previewExample = controls.styledText();
        this.previewExample.setEditable(false);
        this.previewExample.setToolTipText("Sample value - Double click to edit");
        FormLayoutUtils.attach((Control)this.previewExample).topFrom((Control)previewLabel, 5).left().right();
    }

    @Override
    public void refresh() {
        this.initialize(this.element);
    }

    private void initialize(FixedWidthTableElement<?> element) {
        this.widthSpinner.setSelection(element.getWidth());
        this.alignLeft.setSelection(false);
        this.alignRight.setSelection(false);
        this.pattern.setEnabled(false);
        this.pattern.setText("");
        Optional<TypeFormatConstants.FillMode> alignMaybe = element.getAlign();
        Optional<String> patternMaybe = element.getPattern();
        this.configureAlignment(alignMaybe.isPresent() ? (TypeFormatConstants.FillMode)alignMaybe.get() : null);
        this.configurePattern(patternMaybe);
        this.previewExample.setText("\n" + this.applyFormats() + "\n");
    }

    private void configureAlignment(TypeFormatConstants.FillMode fillMode) {
        switch (fillMode) {
            case LEFT: {
                this.alignLeft.setSelection(true);
                break;
            }
            case RIGHT: {
                this.alignRight.setSelection(true);
                break;
            }
            default: {
                this.alignLeft.setSelection(false);
                this.alignRight.setSelection(true);
            }
        }
    }

    private void configurePattern(Optional<String> patternMaybe) {
        if (patternMaybe.isPresent()) {
            this.pattern.setEnabled(true);
            this.formatPattern.setSelection(true);
            this.pattern.setText((String)patternMaybe.get());
        }
    }

    private TypeFormatConstants.FillMode getAlignment() {
        return this.alignLeft.getSelection() ? TypeFormatConstants.FillMode.LEFT : TypeFormatConstants.FillMode.RIGHT;
    }

    private String applyFormats() {
        try {
            TypeFormatConstants.FillMode fillMode = this.getAlignment();
            TypeFormat formatter = null;
            formatter = this.formatPattern.getSelection() && !this.pattern.getText().isEmpty() ? LocalDateFormat$.MODULE$.apply(this.widthSpinner.getSelection(), fillMode, this.pattern.getText()) : LocalDateFormat$.MODULE$.apply(this.widthSpinner.getSelection(), fillMode);
            Calendar calendar = Calendar.getInstance();
            Date date = new Date();
            calendar.setTime(date);
            calendar.add(2, 1);
            String previewResult = DemoSupport.writeString((Object)calendar, (TypeFormat)formatter);
            previewResult = previewResult.replace(' ', '.');
            return previewResult;
        }
        catch (Exception e) {
            return "Preview Error: " + e.getMessage();
        }
    }

    @Override
    public FixedWidthTableElement<?> getResult() {
        FieldFormatAnnotation formats = new FieldFormatAnnotation(Integer.valueOf(this.widthSpinner.getSelection()));
        formats.withAlign(this.getAlignment().name());
        if (this.formatPattern.getSelection() && !this.pattern.getText().isEmpty()) {
            formats.withPattern(this.pattern.getText());
        }
        return new FixedWidthTableElement<MetadataType>(this.element.getQname(), this.type, formats);
    }

    private final class FormatPatternListener
    extends SelectionAdapter {
        private SelectionAdapter previewListener;

        public FormatPatternListener(SelectionAdapter previewListener) {
            this.previewListener = previewListener;
        }

        public void widgetSelected(SelectionEvent e) {
            boolean isSelected = ((Button)e.getSource()).getSelection();
            DateFixedWidthTypeEditor.this.pattern.setEnabled(isSelected);
            if (!isSelected) {
                DateFixedWidthTypeEditor.this.pattern.setText("");
            }
            this.previewListener.widgetSelected(e);
        }
    }

    private final class PreviewListener
    extends SelectionAdapter {
        private PreviewListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            DateFixedWidthTypeEditor.this.previewExample.setText("\n" + DateFixedWidthTypeEditor.this.applyFormats() + "\n");
        }
    }
}

